/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.jasm.JasmEnvironment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.ParseBase;

public class Scanner
extends ParseBase {
    protected int ch;
    protected JasmTokens.Token token;
    protected long pos;
    protected int intValue;
    protected long longValue;
    protected float floatValue;
    protected double doubleValue;
    protected String stringValue;
    protected String idValue;
    protected int radix;
    protected String docComment;
    protected long prevPos;
    protected int sign;
    protected boolean inBits;
    private int count;
    private char[] buffer = new char[32];
    private Predicate<Integer> escapingAllowed;
    private final Predicate<Integer> noFunc = ch -> false;
    private final Predicate<Integer> yesAndProcessFunc = ch -> {
        boolean res;
        boolean bl = res = ch == 92 || ch == 58 || ch == 64;
        if (res) {
            this.putCh(92);
        }
        return res;
    };

    protected Scanner(JasmEnvironment environment) {
        super.init(environment);
        this.escapingAllowed = this.noFunc;
        this.ch = environment.read();
        this.xscan();
    }

    protected void scanModuleStatement() {
        try {
            this.escapingAllowed = this.yesAndProcessFunc;
            this.scan();
        }
        finally {
            this.escapingAllowed = this.noFunc;
        }
    }

    protected void scan() {
        int signloc = 1;
        this.prevPos = this.pos;
        block6: while (true) {
            this.xscan();
            switch (this.token) {
                case SIGN: {
                    signloc *= this.intValue;
                    continue block6;
                }
            }
            break;
        }
        switch (this.token) {
            case INTVAL: 
            case LONGVAL: 
            case FLOATVAL: 
            case DOUBLEVAL: 
            case INF: 
            case NAN: {
                this.sign = signloc;
                break;
            }
        }
    }

    protected final boolean checkTokenIdent() {
        return this.token.isPossibleJasmIdentifier();
    }

    protected final void expect(JasmTokens.Token t) throws SyntaxError {
        this.check(t);
        this.scan();
    }

    protected final void expectIdentContent(JasmTokens.Token t) throws SyntaxError {
        if (this.token != JasmTokens.Token.IDENT || !this.stringValue.equals(t.parseKey())) {
            this.environment.throwErrorException(this.pos, "err.token.expected", "\"" + t.parseKey() + "\"");
        }
        this.scan();
    }

    protected final void expectOneOf(List<String> identifiers, JasmTokens.Token ... tokens) throws SyntaxError {
        boolean foundTokens = this.expectOneOfToken(tokens);
        boolean foundIdents = this.expectOneOfIdent(identifiers.toArray(new String[0]));
        if (!foundTokens && !foundIdents) {
            String list = identifiers.stream().map(arg_0 -> Scanner.lambda$expectOneOf$2("\"%s\"", arg_0)).collect(Collectors.joining(","));
            list = "[ %s,%s ]".formatted(list, Arrays.stream(tokens).map(t -> "\"%s\"".formatted(t.parseKey())).collect(Collectors.joining(",")));
            this.environment.error(this.pos, "err.one.of.N.token.expected", list);
        }
    }

    protected final boolean expectOneOfToken(JasmTokens.Token ... tokens) throws SyntaxError {
        for (JasmTokens.Token t : tokens) {
            if (this.token != t) continue;
            return true;
        }
        return false;
    }

    protected final boolean expectOneOfIdent(String ... identifiers) throws SyntaxError {
        if (this.token == JasmTokens.Token.IDENT) {
            for (String ident : identifiers) {
                if (!this.stringValue.equals(ident)) continue;
                return true;
            }
        }
        return false;
    }

    protected final void check(JasmTokens.Token t) throws SyntaxError {
        if (!(this.token == t || t == JasmTokens.Token.IDENT && this.checkTokenIdent())) {
            this.environment.traceln("expect: " + t + " instead of " + this.token, new Object[0]);
            if (t == JasmTokens.Token.IDENT) {
                this.environment.error(this.pos, "err.identifier.expected", new Object[0]);
            } else {
                this.environment.error(this.pos, "err.token.expected", "<" + t.parseKey() + ">");
            }
        }
    }

    private void putCh(int ch) {
        if (this.count == this.buffer.length) {
            char[] newBuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.count++] = (char)ch;
    }

    private String bufferString() {
        char[] buf = new char[this.count];
        System.arraycopy(this.buffer, 0, buf, 0, this.count);
        return new String(buf);
    }

    private void skipComment() {
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.comment", new Object[0]);
                    return;
                }
                case 42: {
                    this.ch = this.environment.read();
                    if (this.ch != 47) continue block4;
                    this.ch = this.environment.read();
                    return;
                }
            }
            this.ch = this.environment.read();
        }
    }

    private String scanDocComment() {
        this.count = 0;
        if (this.ch == 42) {
            do {
                this.ch = this.environment.read();
            } while (this.ch == 42);
            if (this.ch == 47) {
                this.ch = this.environment.read();
                return "";
            }
        }
        switch (this.ch) {
            case 10: 
            case 32: {
                this.ch = this.environment.read();
            }
        }
        boolean seenstar = false;
        int c = this.count;
        block14: while (true) {
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.comment", new Object[0]);
                    return this.bufferString();
                }
                case 10: {
                    this.putCh(10);
                    this.ch = this.environment.read();
                    seenstar = false;
                    c = this.count;
                    continue block14;
                }
                case 9: 
                case 32: {
                    this.putCh(this.ch);
                    this.ch = this.environment.read();
                    continue block14;
                }
                case 42: {
                    if (seenstar) {
                        this.ch = this.environment.read();
                        if (this.ch == 47) {
                            this.ch = this.environment.read();
                            this.count = c;
                            return this.bufferString();
                        }
                        this.putCh(42);
                        continue block14;
                    }
                    seenstar = true;
                    this.count = c;
                    while ((this.ch = this.environment.read()) == 42) {
                    }
                    switch (this.ch) {
                        case 32: {
                            this.ch = this.environment.read();
                            break;
                        }
                        case 47: {
                            this.ch = this.environment.read();
                            this.count = c;
                            return this.bufferString();
                        }
                    }
                    continue block14;
                }
            }
            if (!seenstar) {
                seenstar = true;
            }
            this.putCh(this.ch);
            this.ch = this.environment.read();
            c = this.count;
        }
    }

    private void scanCPRef() {
        int prevCh = this.ch;
        this.ch = this.environment.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                boolean overflow = false;
                long value = this.ch - 48;
                this.count = 0;
                this.putCh(this.ch);
                block6: while (true) {
                    this.ch = this.environment.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.putCh(this.ch);
                            if (overflow) continue block6;
                            overflow = (value = value * 10L + (long)(this.ch - 48)) > 65535L;
                            continue block6;
                        }
                    }
                    break;
                }
                this.intValue = (int)value;
                this.stringValue = this.bufferString();
                this.token = JasmTokens.Token.CPINDEX;
                if (!overflow) break;
                this.environment.error(this.pos, "err.overflow", new Object[0]);
                break;
            }
            default: {
                this.stringValue = Character.toString((char)prevCh);
                this.environment.throwErrorException(this.environment.getPosition(), "err.invalid.number", this.stringValue);
                this.intValue = 0;
                this.token = JasmTokens.Token.CPINDEX;
                this.ch = this.environment.read();
            }
        }
    }

    private void scanNumber() {
        boolean seenNonOctal = false;
        boolean overflow = false;
        this.radix = this.ch == 48 ? 8 : 10;
        long value = this.ch - 48;
        this.count = 0;
        this.putCh(this.ch);
        block9: while (true) {
            this.ch = this.environment.read();
            switch (this.ch) {
                case 46: {
                    if (this.radix == 16) break block9;
                    this.scanReal();
                    return;
                }
                case 56: 
                case 57: {
                    seenNonOctal = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    this.putCh(this.ch);
                    if (this.radix == 10) {
                        overflow = overflow || value * 10L / 10L != value;
                        value = value * 10L + (long)(this.ch - 48);
                        overflow = overflow || value - 1L < -1L;
                        continue block9;
                    }
                    if (this.radix == 8) {
                        overflow = overflow || value >>> 61 != 0L;
                        value = (value << 3) + (long)(this.ch - 48);
                        continue block9;
                    }
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + (long)(this.ch - 48);
                    continue block9;
                }
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    if (this.radix != 16) {
                        this.scanReal();
                        return;
                    }
                }
                case 65: 
                case 66: 
                case 67: 
                case 97: 
                case 98: 
                case 99: {
                    this.putCh(this.ch);
                    if (this.radix != 16) break block9;
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + 10L + (long)Character.toLowerCase((char)this.ch) - 97L;
                    continue block9;
                }
                case 76: 
                case 108: {
                    this.ch = this.environment.read();
                    this.longValue = value;
                    this.token = JasmTokens.Token.LONGVAL;
                    break block9;
                }
                case 88: 
                case 120: {
                    if (this.count != 1 || this.radix != 8) break block9;
                    this.radix = 16;
                    continue block9;
                }
                default: {
                    this.intValue = (int)value;
                    this.token = JasmTokens.Token.INTVAL;
                    break block9;
                }
            }
            break;
        }
        if (Character.isLetterOrDigit(this.ch) || this.ch == 46) {
            this.environment.error(this.environment.getPosition(), "err.invalid.number", Character.toString((char)this.ch));
            do {
                this.ch = this.environment.read();
            } while (Character.isLetterOrDigit(this.ch) || this.ch == 46);
            this.intValue = 0;
            this.token = JasmTokens.Token.INTVAL;
        } else if (this.radix == 8 && seenNonOctal) {
            this.intValue = 0;
            this.token = JasmTokens.Token.INTVAL;
            this.environment.error(this.environment.getPosition(), "err.invalid.octal.number", new Object[0]);
        } else if (overflow || this.token == JasmTokens.Token.INTVAL && (this.radix == 10 ? this.intValue - 1 < -1 : (value & 0xFFFFFFFF00000000L) != 0L)) {
            this.intValue = 0;
            this.longValue = 0L;
            this.environment.error(this.pos, "err.overflow", new Object[0]);
        }
    }

    private void scanReal() {
        char lastChar;
        boolean seenExponent = false;
        boolean isSingleFloat = false;
        if (this.ch == 46) {
            this.putCh(this.ch);
            this.ch = this.environment.read();
        }
        block9: while (true) {
            switch (this.ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putCh(this.ch);
                    break;
                }
                case 69: 
                case 101: {
                    if (seenExponent) break block9;
                    this.putCh(this.ch);
                    seenExponent = true;
                    break;
                }
                case 43: 
                case 45: {
                    lastChar = this.buffer[this.count - 1];
                    if (lastChar != 'e' && lastChar != 'E') break block9;
                    this.putCh(this.ch);
                    break;
                }
                case 70: 
                case 102: {
                    this.ch = this.environment.read();
                    isSingleFloat = true;
                    break block9;
                }
                case 68: 
                case 100: {
                    this.ch = this.environment.read();
                }
                default: {
                    break block9;
                }
            }
            this.ch = this.environment.read();
        }
        if (Character.isLetterOrDigit(this.ch) || this.ch == 46) {
            this.environment.error(this.environment.getPosition(), "err.invalid.number", Character.toString((char)this.ch));
            do {
                this.ch = this.environment.read();
            } while (Character.isLetterOrDigit(this.ch) || this.ch == 46);
            this.doubleValue = 0.0;
            this.token = JasmTokens.Token.DOUBLEVAL;
        } else {
            this.token = isSingleFloat ? JasmTokens.Token.FLOATVAL : JasmTokens.Token.DOUBLEVAL;
            try {
                lastChar = this.buffer[this.count - 1];
                if (lastChar == 'e' || lastChar == 'E' || lastChar == '+' || lastChar == '-') {
                    this.environment.error(this.environment.getPosition() - 1L, "err.float.format", new Object[0]);
                } else if (isSingleFloat) {
                    this.floatValue = Float.parseFloat(this.bufferString());
                    if (Float.isInfinite(this.floatValue)) {
                        this.environment.error(this.pos, "err.overflow", new Object[0]);
                    }
                } else {
                    this.doubleValue = Double.parseDouble(this.bufferString());
                    if (Double.isInfinite(this.doubleValue)) {
                        this.environment.error(this.pos, "err.overflow", new Object[0]);
                        this.environment.error(this.pos, "err.overflow", new Object[0]);
                    }
                }
            }
            catch (NumberFormatException ee) {
                this.environment.error(this.pos, "err.float.format", new Object[0]);
                this.doubleValue = 0.0;
                this.floatValue = 0.0f;
            }
        }
    }

    private long scanEscapeChar() {
        long p = this.environment.getPosition();
        this.ch = this.environment.read();
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n = this.ch - 48;
                block15: for (int i = 2; i > 0; --i) {
                    this.ch = this.environment.read();
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n = (n << 3) + this.ch - 48;
                            continue block15;
                        }
                        default: {
                            if (n > 255) {
                                this.environment.error(p, "err.invalid.escape.char", new Object[0]);
                            }
                            return n;
                        }
                    }
                }
                this.ch = this.environment.read();
                if (n > 255) {
                    this.environment.error(p, "err.invalid.escape.char", new Object[0]);
                }
                return n;
            }
            case 114: {
                this.ch = this.environment.read();
                return 13L;
            }
            case 110: {
                this.ch = this.environment.read();
                return 10L;
            }
            case 102: {
                this.ch = this.environment.read();
                return 12L;
            }
            case 98: {
                this.ch = this.environment.read();
                return 8L;
            }
            case 116: {
                this.ch = this.environment.read();
                return 9L;
            }
            case 92: {
                this.ch = this.environment.read();
                return 92L;
            }
            case 34: {
                this.ch = this.environment.read();
                return 34L;
            }
            case 39: {
                this.ch = this.environment.read();
                return 39L;
            }
            case 117: {
                int unich = this.environment.convertUnicode();
                this.ch = this.environment.read();
                return unich;
            }
        }
        return 92L;
    }

    private void scanString() {
        this.token = JasmTokens.Token.STRINGVAL;
        this.count = 0;
        this.ch = this.environment.read();
        block6: while (true) {
            switch (this.ch) {
                case -1: {
                    this.environment.error(this.pos, "err.eof.in.string", new Object[0]);
                    this.stringValue = this.bufferString();
                    return;
                }
                case 10: {
                    this.ch = this.environment.read();
                    this.environment.error(this.pos, "err.newline.in.string", new Object[0]);
                    this.stringValue = this.bufferString();
                    return;
                }
                case 34: {
                    this.ch = this.environment.read();
                    this.stringValue = this.bufferString();
                    return;
                }
                case 92: {
                    long c = this.scanEscapeChar();
                    if (c < 0L) continue block6;
                    this.putCh((char)c);
                    continue block6;
                }
            }
            this.putCh(this.ch);
            this.ch = this.environment.read();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void scanIdentifier(char[] prefix) {
        block15: {
            this.count = 0;
            if (prefix != null) {
                while (true) lbl-1000:
                // 4 sources

                {
                    for (char c : prefix) {
                        this.putCh(c);
                    }
                    this.ch = this.environment.read();
                    if (this.ch != 92) break block15;
                    this.ch = this.environment.read();
                    if (this.ch == 117) {
                        this.ch = this.environment.convertUnicode();
                        if (Character.isLetterOrDigit(this.ch)) break;
                        prefix = new char[]{(char)this.ch};
                        ** continue;
                    }
                    if (!this.escapingAllowed.test(this.ch)) break;
                    prefix = new char[]{(char)this.ch};
                }
                p = this.environment.getPosition();
                this.environment.error(p, "err.invalid.escape.char", new Object[0]);
            }
        }
        firstChar = this.ch;
        firstIteration = true;
        block6: while (true) {
            this.putCh(this.ch);
            this.ch = this.environment.read();
            if (firstIteration && firstChar == 64) {
                if (this.ch == 84) {
                    this.putCh(this.ch);
                    this.ch = this.environment.read();
                }
                if (this.ch == 43 || this.ch == 45) {
                    this.putCh(this.ch);
                    this.ch = this.environment.read();
                }
                this.stringValue = this.idValue = this.bufferString();
                this.token = JasmTokens.Token.ANNOTATION;
                return;
            }
            firstIteration = false;
            if (Character.isJavaIdentifierPart(this.ch) || StringUtils.isOneOf(this.ch, new char[]{'-', '[', ']', '(', ')', '<', '>'})) continue;
            switch (this.ch) {
                case 47: {
                    c = this.environment.lookForward();
                    if (c != 42 && c != 47) continue block6;
                    break block6;
                }
                case 92: {
                    this.ch = this.environment.read();
                    if (this.ch == 117) {
                        this.ch = this.environment.convertUnicode();
                        if (!Character.isLetterOrDigit(this.ch)) {
                            continue block6;
                        }
                    } else {
                        if (!this.escapingAllowed.test(this.ch)) ** break;
                        continue block6;
                    }
                    p = this.environment.getPosition();
                    this.environment.error(p, "err.invalid.escape.char", new Object[0]);
                }
            }
            break;
        }
        this.stringValue = this.idValue = this.bufferString();
        this.token = JasmTokens.keyword_token_ident(this.idValue);
        this.traceMethodInfoLn("token = %s value = '%s'".formatted(new Object[]{this.token, this.idValue}));
    }

    protected final void xscan() {
        this.docComment = null;
        block7: while (true) {
            long lineOffset;
            long ln;
            this.pos = this.environment.getPosition();
            if (Character.isLetter(this.ch) || StringUtils.isOneOf(this.ch, '$', '_', '@', '[', ']', '(', ')', '<', '>')) {
                this.scanIdentifier(null);
                break;
            }
            if (this.ch == -1) {
                this.token = JasmTokens.Token.EOF;
                break;
            }
            if (this.ch == 10 || this.ch == 13 || this.ch == 32 || this.ch == 9 || this.ch == 12) {
                this.ch = this.environment.read();
                continue;
            }
            if (this.ch == 47) {
                this.ch = this.environment.read();
                switch (this.ch) {
                    case 47: {
                        while (true) {
                            if ((this.ch = this.environment.read()) == -1 || this.ch == 10) continue block7;
                        }
                    }
                    case 42: {
                        this.ch = this.environment.read();
                        if (this.ch == 42) {
                            this.docComment = this.scanDocComment();
                            continue block7;
                        }
                        this.skipComment();
                        continue block7;
                    }
                }
                this.token = JasmTokens.Token.DIV;
                break;
            }
            if (this.ch == 34) {
                this.scanString();
                break;
            }
            if (this.ch == 45) {
                this.intValue = -1;
                this.token = JasmTokens.Token.SIGN;
                this.ch = this.environment.read();
                break;
            }
            if (this.ch == 43) {
                this.intValue = 1;
                this.ch = this.environment.read();
                this.token = JasmTokens.Token.SIGN;
                break;
            }
            if (this.ch == 48 || this.ch == 49 || this.ch == 50 || this.ch == 51 || this.ch == 52 || this.ch == 53 || this.ch == 54 || this.ch == 55 || this.ch == 56 || this.ch == 57) {
                this.scanNumber();
                break;
            }
            if (this.ch == 46) {
                this.ch = this.environment.read();
                switch (this.ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.count = 0;
                        this.putCh(46);
                        this.scanReal();
                        break;
                    }
                    default: {
                        this.token = JasmTokens.Token.FIELD;
                        break;
                    }
                }
                break;
            }
            if (this.ch == 123) {
                this.ch = this.environment.read();
                this.token = JasmTokens.Token.LBRACE;
                break;
            }
            if (this.ch == 125) {
                this.ch = this.environment.read();
                this.token = JasmTokens.Token.RBRACE;
                break;
            }
            if (this.ch == 44) {
                this.ch = this.environment.read();
                this.token = JasmTokens.Token.COMMA;
                break;
            }
            if (this.ch == 59) {
                this.ch = this.environment.read();
                this.token = JasmTokens.Token.SEMICOLON;
                break;
            }
            if (this.ch == 58) {
                this.ch = this.environment.read();
                this.token = JasmTokens.Token.COLON;
                break;
            }
            if (this.ch == 61) {
                this.ch = this.environment.read();
                if (this.ch == 61) {
                    this.ch = this.environment.read();
                    this.token = JasmTokens.Token.EQ;
                    break;
                }
                this.token = JasmTokens.Token.ASSIGN;
                break;
            }
            if (this.ch == 26) {
                this.ch = this.environment.read();
                if (this.ch == -1) {
                    this.token = JasmTokens.Token.EOF;
                    break;
                }
                this.environment.warning(this.prevPos, "warn.funny.char", this.ch);
                this.ch = this.environment.read();
                continue;
            }
            if (this.ch == 35) {
                int c = this.environment.lookForward();
                if (c == 123) {
                    this.ch = this.environment.read();
                    this.token = JasmTokens.Token.PARAM_NAME;
                    break;
                }
                this.scanCPRef();
                break;
            }
            if (this.ch == 92) {
                this.ch = this.environment.read();
                if (this.ch == 117) {
                    this.ch = this.environment.convertUnicode();
                    if (Character.isLetterOrDigit(this.ch) && !Character.isDigit(this.ch)) {
                        this.scanIdentifier(null);
                        break;
                    }
                } else if (this.escapingAllowed.test(this.ch)) {
                    this.scanIdentifier(new char[]{'\\', (char)this.ch});
                    break;
                }
                ln = this.environment.lineNumber(this.pos);
                lineOffset = this.environment.lineOffset(ln, this.pos);
                this.environment.traceln(() -> "Funny char with code='%c' at %d:%d".formatted(this.ch, ln, lineOffset));
                this.environment.warning(this.pos, "warn.funny.char", this.ch);
                this.ch = this.environment.read();
                continue;
            }
            ln = this.environment.lineNumber(this.pos);
            lineOffset = this.environment.lineOffset(ln, this.pos);
            this.environment.traceln(() -> "Funny char with code='%c' at %d:%d".formatted(this.ch, ln, lineOffset));
            this.environment.warning(this.pos, "warn.funny.char", this.ch);
            this.ch = this.environment.read();
        }
    }

    protected void debugScan(String debStr) {
        if (this.environment.isTraceFlag()) {
            if (this.token == null) {
                this.environment.traceln(debStr.concat("<<<NULL TOKEN>>>"), new Object[0]);
                return;
            }
            this.environment.trace(debStr.concat(this.token.toString()), new Object[0]);
            switch (this.token) {
                case IDENT: {
                    this.environment.traceln(" = '" + this.stringValue + "' {idValue = '" + this.idValue + "'}", new Object[0]);
                    break;
                }
                case STRINGVAL: {
                    this.environment.traceln(" = {stringValue}: \"" + this.stringValue + "\"", new Object[0]);
                    break;
                }
                case INTVAL: {
                    this.environment.traceln(" = {intValue}: " + this.intValue, new Object[0]);
                    break;
                }
                case FLOATVAL: {
                    this.environment.traceln(" = {floatValue}: " + this.floatValue, new Object[0]);
                    break;
                }
                case DOUBLEVAL: {
                    this.environment.traceln(" = {doubleValue}: " + this.doubleValue, new Object[0]);
                    break;
                }
                default: {
                    this.environment.traceln("", new Object[0]);
                }
            }
        }
    }

    protected void debugScan(long position, String debStr) {
        if (this.environment.isTraceFlag()) {
            long lineNumber = this.environment.lineNumber(position);
            long linePos = this.environment.lineOffset(lineNumber, position);
            this.debugScan("[%4d,%-2d] ".formatted(lineNumber, linePos).concat(debStr));
        }
    }

    private static /* synthetic */ String lambda$expectOneOf$2(String rec$, Object xva$0) {
        return "\"%s\"".formatted(xva$0);
    }
}

