/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;

public class SourceDebugExtensionAttr
extends AttrData {
    StringBuilder utf8DebugExtension = new StringBuilder();
    List<Byte> byteDebugExtension = new ArrayList<Byte>();
    Type type = Type.NONE;

    SourceDebugExtensionAttr(ConstantPool pool) {
        super(pool, EAttribute.ATT_SourceDebugExtension);
    }

    public boolean isEmpty() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.UTF8 -> this.utf8DebugExtension.isEmpty();
            case Type.BYTE -> this.byteDebugExtension.isEmpty();
            case Type.NONE -> true;
        };
    }

    public void append(String str) throws IllegalArgumentException {
        if (this.type == Type.BYTE) {
            throw new IllegalArgumentException("The valid modified UTF-8 string is expected.");
        }
        this.utf8DebugExtension.append(str);
        this.type = Type.UTF8;
    }

    public void append(int value) {
        if (this.type == Type.UTF8) {
            throw new IllegalArgumentException("The byte representation of the string is expected.");
        }
        this.byteDebugExtension.add((byte)value);
        this.type = Type.BYTE;
    }

    @Override
    public int attrLength() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.UTF8 -> this.utf8DebugExtension.toString().getBytes(StandardCharsets.UTF_8).length;
            case Type.BYTE -> this.byteDebugExtension.size();
            case Type.NONE -> 0;
        };
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        switch (this.type) {
            case UTF8: {
                out.writeBytes(this.utf8DebugExtension.toString());
                break;
            }
            case BYTE: {
                out.write(HexUtils.toByteArray(this.byteDebugExtension));
                break;
            }
            case NONE: {
                out.write(0);
            }
        }
    }

    public static enum Type {
        NONE,
        UTF8,
        BYTE;

    }
}

