/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.function.Function;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstCell;
import org.openjdk.asmtools.jasm.ConstValue;
import org.openjdk.asmtools.jasm.ConstantPool;

public class SourceFileAttr
extends AttrData {
    private String sourceFileName;
    private ConstCell sourceFileNameCell = null;

    public SourceFileAttr(ConstantPool pool, String sourceFileName) {
        super(pool, EAttribute.ATT_SourceFile);
        this.sourceFileName = sourceFileName;
    }

    public SourceFileAttr(ConstantPool pool, ConstCell sourceFileNameCell) {
        super(pool, EAttribute.ATT_SourceFile);
        this.sourceFileNameCell = sourceFileNameCell;
    }

    public SourceFileAttr updateIfFound(ConstantPool pool, Function<String, Boolean> rule) {
        this.sourceFileNameCell = pool.lookupUTF8Cell(rule);
        if (this.sourceFileNameCell != null) {
            ((ConstValue)this.sourceFileNameCell.ref).value = this.sourceFileName;
        } else {
            this.sourceFileNameCell = pool.findUTF8Cell(this.sourceFileName);
        }
        return this;
    }

    @Override
    public int attrLength() {
        return 2;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        if (this.sourceFileNameCell != null) {
            super.write(out);
            out.writeShort(this.sourceFileNameCell.cpIndex);
        }
    }
}

