/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.EnclosingMethodData;
import org.openjdk.asmtools.jdis.ExceptionData;
import org.openjdk.asmtools.jdis.FieldData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.InnerClassData;
import org.openjdk.asmtools.jdis.LineNumberData;
import org.openjdk.asmtools.jdis.LocalVariableData;
import org.openjdk.asmtools.jdis.LocalVariableTypeData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.NestHostData;
import org.openjdk.asmtools.jdis.NestMembersData;
import org.openjdk.asmtools.jdis.RecordData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.SourceFileData;
import org.openjdk.asmtools.jdis.StackMapData;

public class TableFormatModel {

    public static enum Token {
        NOT_SUPPORTED("NotSupported", null, null, null),
        SOURCE_FILE("SourceFile", EAttribute.ATT_SourceFile, JasmTokens.Token.SOURCEFILE, SourceFileData.class),
        ENCLOSING_METHOD("EnclosingMethod", EAttribute.ATT_EnclosingMethod, JasmTokens.Token.ENCLOSINGMETHOD, EnclosingMethodData.class),
        NEST_MEMBERS("NestMembers", EAttribute.ATT_NestMembers, JasmTokens.Token.NESTMEMBERS, NestMembersData.class),
        NEST_HOST("NestHost", EAttribute.ATT_NestHost, JasmTokens.Token.NESTHOST, NestHostData.class),
        INNER_CLASSES("InnerClasses", EAttribute.ATT_InnerClasses, JasmTokens.Token.INNERCLASS, InnerClassData.class),
        SIGNATURE("Signature", EAttribute.ATT_Signature, JasmTokens.Token.SIGNATURE, SignatureData.class),
        CONSTANT_POOL("Constant pool", null, null, ConstantPool.class),
        METHOD_DATA("Method_info", null, null, MethodData.class),
        FIELD_DATA("Field_info", null, null, FieldData.class),
        RECORD_DATA("record_component_info", null, null, RecordData.class),
        LINE_NUMBERS("LineNumberTable", EAttribute.ATT_LineNumberTable, JasmTokens.Token.LINETABLE_HEADER, LineNumberData.class),
        LOCAL_VARIABLES("LocalVariableTable", EAttribute.ATT_LocalVariableTable, JasmTokens.Token.LOCALVARIABLES_HEADER, LocalVariableData.class),
        LOCAL_VARIABLE_TYPES("LocalVariableTypeTable", EAttribute.ATT_LocalVariableTypeTable, JasmTokens.Token.LOCALVARIABLETYPES_HEADER, LocalVariableTypeData.class),
        EXCEPTIONS("throws", null, JasmTokens.Token.THROWS, ExceptionData.class),
        STACK_MAP("StackMap", EAttribute.ATT_StackMap, JasmTokens.Token.STACKMAP, StackMapData.class),
        STACK_MAP_TABLE("StackMapTable", EAttribute.ATT_StackMapTable, JasmTokens.Token.STACKMAPTABLE_HEADER, StackMapData.class),
        BOOTSTRAP_METHOD("BootstrapMethods", EAttribute.ATT_BootstrapMethods, JasmTokens.Token.BOOTSTRAPMETHOD, BootstrapMethodData.class);

        private final String parseKey;
        private final EAttribute attribute;
        private final JasmTokens.Token jasmToken;
        private final String printKey;
        private final Class<? extends Indenter> owner;

        private Token(String parseKey, EAttribute attribute, JasmTokens.Token jasmToken, Class<? extends Indenter> owner) {
            this.parseKey = parseKey;
            this.attribute = attribute;
            this.jasmToken = jasmToken;
            this.printKey = "%s".formatted(parseKey);
            this.owner = owner;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String printKey() {
            return this.printKey;
        }

        public boolean isExtendedPrintingSupported() {
            return this.owner != null;
        }

        public EAttribute getAttribute() {
            return this.attribute;
        }

        public JasmTokens.Token getJasmToken() {
            return this.jasmToken;
        }

        public static Token getBy(Class<? extends Indenter> cls) {
            for (Token item : Token.values()) {
                if (!cls.equals(item.owner)) continue;
                return item;
            }
            return NOT_SUPPORTED;
        }
    }
}

