/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.DataWriter;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;

public abstract class TypeAnnotationTargetInfoData
implements DataWriter {
    protected TypeAnnotationTypes.ETargetType targetType;

    public TypeAnnotationTargetInfoData(TypeAnnotationTypes.ETargetType targetType) {
        this.targetType = targetType;
    }

    public TypeAnnotationTypes.ETargetType getTargetType() {
        return this.targetType;
    }

    public String toPrintString() {
        String targetInfo = this._toPrintString();
        return targetInfo.isBlank() ? String.format(" { %s } ", this.targetType._toPrintString()) : String.format(" { %s %s } ", this.targetType._toPrintString(), targetInfo);
    }

    @Override
    public abstract void write(CheckedDataOutputStream var1) throws IOException;

    public String toString() {
        return String.format("%s_target %s", this.targetType.targetInfo().printValue(), this._toString());
    }

    protected abstract String _toPrintString();

    protected abstract String _toString();

    public static class type_argument_target
    extends TypeAnnotationTargetInfoData {
        int offset;
        int typeArgumentIndex;

        public type_argument_target(TypeAnnotationTypes.ETargetType targetType, int offset, int index) {
            super(targetType);
            this.offset = offset;
            this.typeArgumentIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.offset);
            out.writeByte(this.typeArgumentIndex);
        }

        @Override
        protected String _toPrintString() {
            return this.offset + " " + this.typeArgumentIndex;
        }

        @Override
        public int getLength() {
            return 3;
        }

        @Override
        protected String _toString() {
            return String.format("{ offset: %d; type_argument_index: %d; }", this.offset, this.typeArgumentIndex);
        }
    }

    public static class offset_target
    extends TypeAnnotationTargetInfoData {
        int offset;

        public offset_target(TypeAnnotationTypes.ETargetType tt, int offset) {
            super(tt);
            this.offset = offset;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.offset);
        }

        @Override
        protected String _toPrintString() {
            return String.valueOf(this.offset);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected String _toString() {
            return String.format("{ offset: %d; }", this.offset);
        }
    }

    public static class catch_target
    extends TypeAnnotationTargetInfoData {
        int exceptionTableIndex;

        public catch_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.exceptionTableIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.exceptionTableIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected String _toString() {
            return String.format("{ exception_table_index: %d; }", this.exceptionTableIndex);
        }

        @Override
        protected String _toPrintString() {
            return String.valueOf(this.exceptionTableIndex);
        }
    }

    public static class localvar_target
    extends TypeAnnotationTargetInfoData {
        ArrayList<LocalVar_Entry> table;

        public localvar_target(TypeAnnotationTypes.ETargetType tt, int size) {
            super(tt);
            this.table = new ArrayList(size);
        }

        public void addEntry(int startPC, int length, int cpx) {
            LocalVar_Entry entry = new LocalVar_Entry(startPC, length, cpx);
            this.table.add(entry);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.table.size());
            for (LocalVar_Entry entry : this.table) {
                entry.write(out);
            }
        }

        @Override
        public int getLength() {
            return 2 + 6 * this.table.size();
        }

        @Override
        protected String _toString() {
            int i = 0;
            String str = String.format("{ %d {", this.table.size());
            for (LocalVar_Entry entry : this.table) {
                str = str.concat(String.format(" [%d]: %s;", i++, entry.toString()));
            }
            return str.concat(" } }");
        }

        @Override
        protected String _toPrintString() {
            StringBuilder sb = new StringBuilder();
            this.table.stream().forEach(e -> sb.append(e._toPrintString()));
            return sb.toString();
        }

        public static class LocalVar_Entry {
            public int startPC;
            public int length;
            public int cpx;

            public LocalVar_Entry(int st, int len, int index) {
                this.startPC = st;
                this.length = len;
                this.cpx = index;
            }

            void write(CheckedDataOutputStream out) throws IOException {
                out.writeShort(this.startPC);
                out.writeShort(this.length);
                out.writeShort(this.cpx);
            }

            public String toString() {
                return String.format("start_pc: %d, length: %d, index: %d", this.startPC, this.length, this.cpx);
            }

            protected String _toPrintString() {
                return "{ " + this.startPC + " " + this.length + " " + this.cpx + " }";
            }
        }
    }

    public static class throws_target
    extends TypeAnnotationTargetInfoData {
        int throwsTypeIndex;

        public throws_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.throwsTypeIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.throwsTypeIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected String _toString() {
            return String.format("{ throws_type_index: %d; }", this.throwsTypeIndex);
        }

        @Override
        protected String _toPrintString() {
            return String.valueOf(this.throwsTypeIndex);
        }
    }

    public static class formal_parameter_target
    extends TypeAnnotationTargetInfoData {
        int formalParamIndex;

        public formal_parameter_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.formalParamIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.formalParamIndex);
        }

        @Override
        protected String _toPrintString() {
            return String.valueOf(this.formalParamIndex);
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        protected String _toString() {
            return String.format("{ formal_parameter_index: %d; }", this.formalParamIndex);
        }
    }

    public static class empty_target
    extends TypeAnnotationTargetInfoData {
        public empty_target(TypeAnnotationTypes.ETargetType tt) {
            super(tt);
        }

        @Override
        protected String _toPrintString() {
            return "";
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        protected String _toString() {
            return "{ }";
        }
    }

    public static class type_parameter_bound_target
    extends TypeAnnotationTargetInfoData {
        int typeParamIndex;
        int boundIndex;

        public type_parameter_bound_target(TypeAnnotationTypes.ETargetType tt, int pindx, int bindx) {
            super(tt);
            this.typeParamIndex = pindx;
            this.boundIndex = bindx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.typeParamIndex);
            out.writeByte(this.boundIndex);
        }

        @Override
        protected String _toPrintString() {
            return this.typeParamIndex + " " + this.boundIndex;
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected String _toString() {
            return String.format("{ type_parameter_index: %d; bound_index: %d; }", this.typeParamIndex, this.boundIndex);
        }
    }

    public static class supertype_target
    extends TypeAnnotationTargetInfoData {
        int superTypeIndex;

        public supertype_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.superTypeIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.superTypeIndex);
        }

        @Override
        public int getLength() {
            return 2;
        }

        @Override
        protected String _toString() {
            return String.format("{ supertype_index: %d; }", this.superTypeIndex);
        }

        @Override
        protected String _toPrintString() {
            return String.valueOf(this.superTypeIndex);
        }
    }

    public static class type_parameter_target
    extends TypeAnnotationTargetInfoData {
        int typeParamIndex;

        public type_parameter_target(TypeAnnotationTypes.ETargetType tt, int index) {
            super(tt);
            this.typeParamIndex = index;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.typeParamIndex);
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        protected String _toString() {
            return String.format("{ type_parameter_index: %d; }", this.typeParamIndex);
        }

        @Override
        protected String _toPrintString() {
            return String.valueOf(this.typeParamIndex);
        }
    }
}

