/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.OutputStream;

class ByteBuffer
extends OutputStream {
    String className;
    byte[] data;
    int length;
    protected int capacityIncrement;

    public ByteBuffer(int initialCapacity, int capacityIncrement) {
        this.data = new byte[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ByteBuffer(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ByteBuffer() {
        this(30);
    }

    public ByteBuffer(byte[] data, int capacityIncrement) {
        this.length = data.length;
        this.data = data;
        this.capacityIncrement = capacityIncrement;
    }

    public ByteBuffer(byte[] data) {
        this(data, 0);
    }

    public final int size() {
        return this.length;
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.data.length;
        if (minCapacity <= oldCapacity) {
            return;
        }
        byte[] oldData = this.data;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.data = new byte[newCapacity];
        System.arraycopy(oldData, 0, this.data, 0, this.length);
    }

    @Override
    public void write(int val) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length++] = (byte)val;
    }

    public void writeAt(int index, long val, int width) {
        for (int i = 0; i < width; ++i) {
            this.data[index + i] = (byte)(val >> (width - 1 - i) * 8);
        }
    }

    public void append(long val, int width) {
        this.ensureCapacity(this.length + width);
        this.writeAt(this.length, val, width);
        this.length += width;
    }
}

