/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.MemberData;

public class AnnotationElement<T extends MemberData<T>>
extends MemberData<T> {
    public int name_cpx;
    public AnnotationValue<T> value = null;

    public AnnotationElement(T data) {
        super(data);
    }

    public static <P extends MemberData<P>> AnnotationValue<P> readValue(DataInputStream in, P data, boolean invisible) throws IOException {
        AnnotationValue val;
        char tg = (char)in.readByte();
        ClassFileConst.AnnotationElementType tag = ClassFileConst.getAnnotationElementType(tg);
        switch (tag) {
            case AE_STRING: 
            case AE_BYTE: 
            case AE_CHAR: 
            case AE_INT: 
            case AE_SHORT: 
            case AE_BOOLEAN: 
            case AE_FLOAT: 
            case AE_DOUBLE: 
            case AE_LONG: 
            case AE_CLASS: {
                short cpx = in.readShort();
                val = new CPX_AnnotationValue<P>(tag, data, cpx);
                break;
            }
            case AE_ENUM: {
                short cpx1 = in.readShort();
                short cpx2 = in.readShort();
                val = new CPX2_AnnotationValue<P>(tag, data, cpx1, cpx2);
                break;
            }
            case AE_ANNOTATION: {
                AnnotationData<P> annotationData = new AnnotationData<P>(data, invisible);
                annotationData.read(in);
                val = new Annotation_AnnotationValue<P>(tag, data, annotationData);
                break;
            }
            case AE_ARRAY: {
                Array_AnnotationValue<P> arrayAnnotationValue;
                val = arrayAnnotationValue = new Array_AnnotationValue<P>(tag, data);
                int cnt = in.readShort();
                for (int i = 0; i < cnt; ++i) {
                    arrayAnnotationValue.add(AnnotationElement.readValue(in, data, invisible));
                }
                break;
            }
            default: {
                if (data.bestEffort) {
                    data.environment.error("err.unknown.tag", Character.valueOf(StringUtils.isPrintableChar(tg) ? tg : (char)'?'), Integer.toHexString(tg));
                    val = new Annotation_AnnotationValue<P>(tag, data, null);
                    break;
                }
                throw new FormatError(data.environment.getLogger(), "err.unknown.tag", new Object[]{Character.valueOf(StringUtils.isPrintableChar(tg) ? tg : (char)'?'), Integer.toHexString(tg)});
            }
        }
        return val;
    }

    public void read(DataInputStream in, boolean invisible) throws IOException {
        this.name_cpx = in.readShort();
        this.value = AnnotationElement.readValue(in, this.data, invisible);
        this.environment.traceln("AnnotationElement: cpIndex#%d=%s value=%s", this.name_cpx, this.pool.getString(this.name_cpx, index -> "????"), this.value.toString());
    }

    public String stringVal() {
        String name = this.pool.getName(this.name_cpx);
        if (this.printCPIndex) {
            return this.skipComments ? String.format("#%d", this.name_cpx) : String.format("#%d /* %s */", this.name_cpx, name);
        }
        return name;
    }

    @Override
    public void print() throws IOException {
        this.printIndent(this.stringVal() + " = ");
        this.value.setTheSame(this).incIndent();
        if (this.value.elementType == ClassFileConst.AnnotationElementType.AE_ARRAY) {
            if (((Array_AnnotationValue)this.value).annotationValues.size() == 0) {
                this.print("{ }");
            } else {
                this.println().print(this.getIndentString());
                this.value.print();
                this.printIndent("}");
            }
        } else {
            this.value.setElementState(this.getAnnotationElementState());
            this.value.print();
        }
    }

    public String toString() {
        return "<AnnotationElement " + this.stringVal() + " = " + this.value.toString() + ">";
    }

    public static class AnnotationValue<T extends MemberData<T>>
    extends MemberData<T> {
        public ClassFileConst.AnnotationElementType elementType;

        public AnnotationValue(ClassFileConst.AnnotationElementType elementType, T data) {
            super(data);
            this.elementType = elementType;
            this.memberType = "AnnotationValue";
        }

        public String toString() {
            return String.format("<%s %s %s>", this.memberType, this.elementType.printValue(), this.stringVal());
        }

        protected String stringVal() {
            return "";
        }

        @Override
        public void print() throws IOException {
            this.print(this.PadLeft(this.elementType.value(), 4));
        }
    }

    public static class CPX_AnnotationValue<T extends MemberData<T>>
    extends AnnotationValue<T> {
        public int cpx;

        public CPX_AnnotationValue(ClassFileConst.AnnotationElementType elementType, T data, int cpx) {
            super(elementType, data);
            this.cpx = cpx;
            this.memberType = "CPX_AnnotationValue";
        }

        @Override
        public String stringVal() {
            StringBuilder sb = new StringBuilder();
            switch (this.elementType) {
                case AE_STRING: {
                    sb.append(this.valueAsString("", () -> StringUtils.Utf8ToString(this.pool.getString(this.cpx, index -> "#" + this.cpx), "\"")));
                    break;
                }
                case AE_BYTE: 
                case AE_CHAR: 
                case AE_SHORT: {
                    sb.append(this.valueAsString(this.elementType.printValue(), () -> this.pool.getConst(this.cpx).stringVal()));
                    break;
                }
                case AE_INT: 
                case AE_FLOAT: 
                case AE_DOUBLE: 
                case AE_LONG: {
                    sb.append(this.valueAsString("", () -> this.pool.getConst(this.cpx).stringVal()));
                    break;
                }
                case AE_BOOLEAN: {
                    sb.append(this.valueAsString(this.elementType.printValue(), () -> (Integer)((ConstantPool.CP_Int)this.pool.getConst((int)this.cpx)).value == 0 ? "false" : "true"));
                    break;
                }
                case AE_CLASS: {
                    sb.append(this.valueAsString(this.elementType.printValue(), () -> this.pool.getName(this.cpx)));
                    break;
                }
            }
            return sb.toString();
        }

        private String valueAsString(String prefix, Supplier<String> supplier) {
            Object str;
            Object object = str = prefix.isEmpty() ? "" : prefix + " ";
            str = this.printCPIndex ? (this.skipComments ? (String)str + String.format("#%d", this.cpx) : (String)str + String.format("#%d /* %s */", this.cpx, supplier.get())) : (String)str + supplier.get();
            return str;
        }

        @Override
        public void print() {
            MemberData.AnnotationElementState state = this.getAnnotationElementState();
            if (state == MemberData.AnnotationElementState.HAS_DEFAULT_VALUE) {
                this.print(this.getDefaultValuePrefix() + "%s }", this.stringVal());
            } else if (state == MemberData.AnnotationElementState.RIGHT_OPERAND) {
                this.print(" %s }", this.stringVal());
            } else {
                this.print(this.stringVal());
            }
        }
    }

    public static class CPX2_AnnotationValue<T extends MemberData<T>>
    extends AnnotationValue<T> {
        public int cpx1;
        public int cpx2;

        public CPX2_AnnotationValue(ClassFileConst.AnnotationElementType elementType, T data, int cpx1, int cpx2) {
            super(elementType, data);
            this.cpx1 = cpx1;
            this.cpx2 = cpx2;
            this.memberType = "CPX2_AnnotationValue";
        }

        @Override
        public String stringVal() {
            StringBuilder sb = new StringBuilder();
            if (this.elementType == ClassFileConst.AnnotationElementType.AE_ENUM) {
                String className = this.pool.getName(this.cpx1);
                String name = this.pool.getName(this.cpx2);
                sb.append(this.elementType.printValue()).append(' ');
                if (this.printCPIndex) {
                    sb.append(String.format("#%d.#%d", this.cpx1, this.cpx2));
                    if (!this.skipComments) {
                        sb.append(String.format(" /* %s.%s */", className, name));
                    }
                } else {
                    sb.append(className).append(".").append(name);
                }
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            return String.format("<%s %s>", this.memberType, this.stringVal());
        }

        @Override
        public void print() {
            if (this.getAnnotationElementState() == MemberData.AnnotationElementState.HAS_DEFAULT_VALUE) {
                this.print(this.getDefaultValuePrefix() + "%s }", this.stringVal());
            } else {
                this.print(this.stringVal());
            }
        }
    }

    public static class Annotation_AnnotationValue<T extends MemberData<T>>
    extends AnnotationValue<T> {
        AnnotationData<T> annotationData;

        public Annotation_AnnotationValue(ClassFileConst.AnnotationElementType annotationElementType, T data, AnnotationData<T> annotationData) {
            super(annotationElementType, data);
            this.annotationData = annotationData;
            this.memberType = "Annotation_AnnotationValue";
        }

        @Override
        public String stringVal() {
            return this.annotationData.toString();
        }

        @Override
        public Annotation_AnnotationValue<T> setElementState(MemberData.AnnotationElementState state) {
            super.setElementState(state);
            this.annotationData.setElementState(state);
            return this;
        }

        @Override
        public void print() throws IOException {
            if (this.annotationData != null) {
                this.annotationData.setCommentOffset(this.getCommentOffset());
                this.annotationData.setTheSame(this);
                this.annotationData.print();
            }
        }
    }

    public static class Array_AnnotationValue<T extends MemberData<T>>
    extends AnnotationValue<T> {
        public ArrayList<AnnotationValue<T>> annotationValues = new ArrayList();

        public Array_AnnotationValue(ClassFileConst.AnnotationElementType elementType, T data) {
            super(elementType, data);
            this.memberType = "Array_AnnotationValue";
        }

        @Override
        public String stringVal() {
            return super.stringVal() + "={" + this.annotationValues.stream().map(AnnotationValue::toString).collect(Collectors.joining(",")) + "}";
        }

        public void add(AnnotationValue<T> annotationValue) {
            this.annotationValues.add(annotationValue);
        }

        @Override
        public void print() throws IOException {
            int count = this.annotationValues.size();
            if (this.annotationValues.size() > 0) {
                MemberData.AnnotationElementState state = this.getAnnotationElementState();
                if (state == MemberData.AnnotationElementState.HAS_DEFAULT_VALUE || state == MemberData.AnnotationElementState.INLINED_ELEMENT) {
                    this.printDefaultAnnotationElement(count);
                } else {
                    this.printAnnotationElement(count);
                }
            } else {
                this.print(this.getDefaultValuePrefix() + "{ } }");
            }
        }

        private <P extends AnnotationValue<T>> int getIndent(P value) {
            if (value instanceof Annotation_AnnotationValue || value instanceof CPX_AnnotationValue) {
                return this.getCommentOffset() + "default { ".length() + this.getIndentSize();
            }
            return 1;
        }

        private int getItemsPerLine(int count, ClassFileConst.AnnotationElementType type) {
            return switch (type) {
                case ClassFileConst.AnnotationElementType.AE_CLASS, ClassFileConst.AnnotationElementType.AE_ENUM, ClassFileConst.AnnotationElementType.AE_ANNOTATION, ClassFileConst.AnnotationElementType.AE_ARRAY -> 1;
                default -> {
                    if (count > 10) {
                        if (count % 2 == 0) {
                            yield 4;
                        }
                        yield 6;
                    }
                    yield count % 2 == 0 ? 2 : 3;
                }
            };
        }

        public void printDefaultAnnotationElement(int count) throws IOException {
            int i = 0;
            int lineIndent = this.getIndent(this.annotationValues.get(0));
            int ItemsPerLine = this.getAnnotationElementState() == MemberData.AnnotationElementState.INLINED_ELEMENT ? 1 : this.getItemsPerLine(count, this.annotationValues.get((int)0).elementType);
            this.println(this.getDefaultValuePrefix() + "{ ");
            this.printPadLeft(INDENT_STRING, 4);
            for (AnnotationValue<T> annotationValue : this.annotationValues) {
                annotationValue.setElementState(MemberData.AnnotationElementState.INLINED_ELEMENT);
                annotationValue.setCommentOffset(lineIndent);
                if ((annotationValue instanceof Annotation_AnnotationValue || annotationValue instanceof CPX_AnnotationValue || annotationValue instanceof CPX2_AnnotationValue) && i % ItemsPerLine == 0 && i != 0) {
                    this.printPadLeft(INDENT_STRING, 4);
                }
                annotationValue.print();
                if (i < count - 1) {
                    this.print("," + (i % ItemsPerLine == ItemsPerLine - 1 ? System.lineSeparator() : " "));
                }
                ++i;
            }
            this.println(" }").print("  }");
        }

        public void printAnnotationElement(int count) throws IOException {
            int i = 0;
            this.println("{");
            for (AnnotationValue<T> annotationValue : this.annotationValues) {
                annotationValue.setTheSame(this);
                if (annotationValue instanceof CPX_AnnotationValue || annotationValue instanceof CPX2_AnnotationValue) {
                    this.print(annotationValue.getIndentString());
                }
                annotationValue.print();
                if (i < count - 1) {
                    this.println(",");
                }
                ++i;
            }
            this.println();
        }
    }
}

