/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.EAttribute;

public class AttrData {
    private final int MAX_DATA_PRINT_SIZE = 10;
    private EAttribute attributeInfo;
    private int name_cpx;
    private int length;
    private byte[] data;
    final Environment environment;

    public AttrData(Environment environment, EAttribute attributeInfo) {
        this.environment = environment;
        this.attributeInfo = attributeInfo;
    }

    public void read(int name_cpx, int attrLength, DataInputStream in) throws IOException {
        this.name_cpx = name_cpx;
        this.length = attrLength;
        try {
            this.data = new byte[attrLength];
            in.readFully(this.data);
            this.environment.traceln("AttrData:#%d length=%d", name_cpx, attrLength);
        }
        catch (ArrayIndexOutOfBoundsException | NegativeArraySizeException ex) {
            throw new FormatError(this.environment.getLogger(), "err.invalid.attribute.length", new Object[]{this.attributeInfo.printValue(), attrLength});
        }
    }

    public String dataAsString() {
        if (this.data != null && this.data.length > 0) {
            int maxLength = Math.min(10, this.data.length);
            Object res = IntStream.range(0, maxLength).mapToObj(i -> HexUtils.toHex(i)).collect(Collectors.joining(", "));
            if (this.data.length > 10) {
                res = (String)res + ", ...";
            }
            return res;
        }
        return "";
    }

    public AttrData setNameCpx(int name_cpx) {
        this.name_cpx = name_cpx;
        return this;
    }

    public AttrData setLength(int length) {
        this.length = length;
        return this;
    }

    public int getNameCpx() {
        return this.name_cpx;
    }

    public int getLength() {
        return this.length;
    }

    public EAttribute getAttributeInfo() {
        return this.attributeInfo;
    }
}

