/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.function.Supplier;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Indenter;

public abstract class AttributeData<A extends AttributeData<A>>
extends Indenter {
    protected ConstantPool pool;
    protected ToolLogger logger;
    protected int attribute_length = 0;
    protected String name = null;
    protected int cpx;
    protected int methodCpx = 0;
    Supplier<String> idxStringSupplier;
    private Printable indexPrinter = () -> this.println(this.idxStringSupplier.get());
    private Printable namePrinter;
    private Printable indexAndNamePrinter = () -> this.print(this.PadRight(this.idxStringSupplier.get(), this.getPrintAttributeCommentPadding())).println(this.name != null ? " // %s".formatted(this.name) : "");

    protected AttributeData(ClassData classData, TableFormatModel.Token token) {
        super(classData.toolOutput);
        this.pool = classData.pool;
        this.logger = ((ClassData)classData.data).environment.getLogger();
        this.tableToken = token;
        switch (this.tableToken) {
            case SOURCE_FILE: {
                this.attribute_length = 2;
                this.idxStringSupplier = () -> "#%d;".formatted(this.cpx);
                this.namePrinter = () -> this.println("\"%s\";".formatted(this.name != null ? this.name : "???"));
                break;
            }
            case NEST_HOST: {
                this.attribute_length = 2;
                this.idxStringSupplier = () -> "#%d;".formatted(this.cpx);
                this.namePrinter = () -> this.println("%s;".formatted(this.name != null ? this.name : "\"???\""));
                break;
            }
            case ENCLOSING_METHOD: {
                this.attribute_length = 4;
                this.idxStringSupplier = () -> "#%d:#%d;".formatted(this.cpx, this.methodCpx);
                this.namePrinter = () -> this.println("%s;".formatted(this.name));
                break;
            }
            default: {
                throw new RuntimeException("Implementation of \"%s\" is not supported".formatted(this.tableToken.parseKey()));
            }
        }
    }

    public A read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        if (attribute_length != this.attribute_length) {
            if (this.bestEffort) {
                this.logger.error("err.invalid.attribute.length", this.tableToken.getAttribute().printValue(), attribute_length);
            } else {
                throw new FormatError(this.logger, "err.invalid.attribute.length", this.tableToken.getAttribute().printValue(), attribute_length);
            }
        }
        this.cpx = in.readUnsignedShort();
        if (this.tableToken == TableFormatModel.Token.ENCLOSING_METHOD) {
            this.methodCpx = in.readUnsignedShort();
        }
        return (A)this;
    }

    @Override
    protected void jasmPrint() {
        this.calculateName();
        this.printIndent(this.PadRight(this.tableToken.getJasmToken().parseKey(), this.getPrintAttributeKeyPadding()));
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.indexPrinter.print();
            } else {
                this.indexAndNamePrinter.print();
            }
        } else {
            this.namePrinter.print();
        }
    }

    @Override
    protected void tablePrint() {
        this.jasmPrint();
    }

    protected abstract String calculateName();

    @FunctionalInterface
    public static interface Printable {
        public void print();
    }
}

