/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Container;
import org.openjdk.asmtools.jdis.Element;

public class BootstrapMethodData
extends Element<ClassData> {
    int bsmRef;
    ArrayList<Integer> bsmArguments;
    int numBsmArgs;
    int indexOffset;

    public BootstrapMethodData(ClassData classData, Container<BootstrapMethodData, ClassData> container) {
        super(classData, container);
        this.tableToken = TableFormatModel.Token.BOOTSTRAP_METHOD;
        this.indexOffset = classData.printProgramCounter ? 7 : 7 - this.getIndentStep();
    }

    @Override
    public boolean isPrintable() {
        return this.bsmArguments != null && !this.bsmArguments.isEmpty();
    }

    public void read(DataInputStream in) throws IOException {
        this.bsmRef = in.readUnsignedShort();
        this.numBsmArgs = in.readUnsignedShort();
        this.bsmArguments = new ArrayList(this.numBsmArgs);
        for (int i = 0; i < this.numBsmArgs; ++i) {
            this.bsmArguments.add(in.readUnsignedShort());
        }
    }

    @Override
    protected void jasmPrint(int index, int size) throws IOException {
        int commentOffset = this.getCommentOffset() - TABLE_PADDING;
        BsmInfo bsmInfo = this.getBsmInfo();
        this.printIndent(this.PadRight(JasmTokens.Token.BOOTSTRAPMETHOD.parseKey(), TABLE_PADDING));
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.println("#%d;".formatted(this.bsmRef));
            } else {
                this.printPadRight("#%d;".formatted(this.bsmRef), commentOffset).println(" // %s".formatted(this.formatOperandLine(bsmInfo.strBsm(), this.getCommentOffset() + this.getIndentSize(), " // ", InvokeDynamicBreakPositions)));
            }
        } else {
            this.println(this.formatOperandLine("%s".formatted(bsmInfo.strBsm()), TABLE_PADDING + this.getIndentStep(), "", BootstrapMethodBreakPositions));
        }
        this.printIndent(this.PadRight(" ", TABLE_PADDING)).print("{ ");
        if (this.numBsmArgs > 0) {
            this.println();
            this.incIndent(2);
            if (this.printCPIndex) {
                for (int i = 0; i < this.numBsmArgs; ++i) {
                    int argRef = this.bsmArguments.get(i);
                    String delim = i != this.numBsmArgs - 1 ? "," : "";
                    boolean notLastIdx = i != this.numBsmArgs - 1;
                    this.printIndent(this.PadRight(" ", TABLE_PADDING));
                    if (this.skipComments) {
                        this.println("#%d%s".formatted(argRef, delim));
                        continue;
                    }
                    String strArg = bsmInfo.cpx2Const().bsmArgWithoutDelimitersAsString(argRef, notLastIdx);
                    strArg = this.formatOperandLine(strArg, this.getCommentOffset() + this.getIndentStep(), " // ", InvokeDynamicBreakPositions);
                    this.printPadRight("#%d%s".formatted(argRef, delim), commentOffset - this.getIndentStep() * 2).println(" // %s".formatted(strArg));
                }
            } else {
                String strArgs = bsmInfo.cpx2Const().bsmArgsAsString(this);
                this.printIndent(this.PadRight(" ", TABLE_PADDING - this.getIndentStep())).println(this.formatOperandLine(strArgs, TABLE_PADDING + this.getIndentStep() * 2, "", BootstrapArgumentsBreakPositions));
            }
            this.decIndent(2);
            this.printIndent(this.PadRight(" ", TABLE_PADDING));
        }
        this.println("}");
        if (index < size - 1) {
            this.println();
        }
    }

    @Override
    protected void tablePrint(int index, int size) throws IOException {
        int commentOffset = this.getCommentOffset() - this.indexOffset - this.getIndentSize();
        BsmInfo bsmInfo = this.getBsmInfo();
        if (index == 0) {
            this.printIndentLn("%s {".formatted(JasmTokens.Token.BOOTSTRAPMETHOD.alias()));
        }
        this.incIndent();
        this.printIndent(this.PadRight(String.format("%2d:", index), this.indexOffset));
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.println("#%d;".formatted(this.bsmRef));
            } else {
                this.printPadRight("#%d;".formatted(this.bsmRef), commentOffset).println(" // %s".formatted(this.formatOperandLine("%s".formatted(bsmInfo.strBsm()), this.getCommentOffset() + this.getIndentStep(), " // ", BootstrapMethodBreakPositions)));
            }
        } else {
            this.println(this.formatOperandLine("%s".formatted(bsmInfo.strBsm()), this.indexOffset + this.getIndentStep() * 2, "", BootstrapMethodBreakPositions));
        }
        if (this.numBsmArgs > 0) {
            this.printIndentLn(" Arguments:");
            if (this.printCPIndex) {
                int argOffs = commentOffset + this.indexOffset + this.getIndentStep() * 2;
                for (int i = 0; i < this.numBsmArgs; ++i) {
                    int argRef = this.bsmArguments.get(i);
                    boolean notLastIdx = i != this.numBsmArgs - 1;
                    String delim = i != this.numBsmArgs - 1 ? "," : ";";
                    this.printIndent(this.PadRight("", this.indexOffset));
                    if (!this.printCPIndex) continue;
                    if (this.skipComments) {
                        this.println("#%d%s".formatted(argRef, delim));
                        continue;
                    }
                    String strArg = bsmInfo.cpx2Const().bsmArgWithoutDelimitersAsString(argRef, notLastIdx);
                    strArg = this.formatOperandLine(strArg, argOffs, " // ", InvokeDynamicBreakPositions);
                    this.printPadRight("#%d%s".formatted(argRef, delim), commentOffset).println(" // %s".formatted(strArg));
                }
            } else {
                String strArgs = bsmInfo.cpx2Const().bsmArgsAsString(this);
                this.printIndent(this.PadRight(" ", this.indexOffset));
                this.println(this.formatOperandLine(strArgs, this.indexOffset + this.getIndentStep() * 2, "", BootstrapArgumentsBreakPositions) + ";");
            }
        }
        if (index < size - 1) {
            this.println();
        } else {
            this.decIndent();
            this.printIndentLn("}");
        }
    }

    private BsmInfo getBsmInfo() {
        Object strBsm;
        ConstantPool.Constant cnt = ((ClassData)this.owner).pool.getConst(this.bsmRef);
        ConstantPool.CPX2 cpx2Const = ((ClassData)this.owner).pool.getCPX2(ConstantPool.TAG.CONSTANT_NULL);
        if (cnt instanceof ConstantPool.CPX2) {
            ConstantPool.CPX2 cpx;
            cpx2Const = cpx = (ConstantPool.CPX2)cnt;
            strBsm = cpx.stringVal() + ";";
        } else {
            strBsm = ((ClassData)this.owner).environment.getInfo("info.corrupted_bootstrap_method_ref", new Object[0]);
            if (!this.printCPIndex) {
                strBsm = this.PadRight("#%d".formatted(this.bsmRef), 25).concat(" // ").concat((String)strBsm);
            }
        }
        BsmInfo bsmInfo = new BsmInfo((String)strBsm, cpx2Const);
        return bsmInfo;
    }

    private record BsmInfo(String strBsm, ConstantPool.CPX2 cpx2Const) {
    }
}

