/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;

public class ClassArrayData
extends MemberData {
    JasmTokens.Token token;
    int[] indexes;

    protected <M extends MemberData<ClassData>> ClassArrayData(M classData, JasmTokens.Token token) {
        super(classData);
        this.token = token;
    }

    public ClassArrayData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        int number_of_entities = in.readUnsignedShort();
        if (attribute_length != 2 + number_of_entities * 2) {
            throw new ClassFormatError("%s_attribute: Invalid attribute length".formatted(this.token.parseKey()));
        }
        this.indexes = new int[number_of_entities];
        for (int i = 0; i < number_of_entities; ++i) {
            this.indexes[i] = in.readUnsignedShort();
        }
        return this;
    }

    @Override
    public void jasmPrint() {
        if (this.indexes.length > 2) {
            this.jasmPrintLong();
        } else {
            this.jasmPrintShort();
        }
    }

    public void jasmPrintShort() {
        StringBuilder indexes = new StringBuilder();
        StringBuilder names = new StringBuilder();
        int lastIndex = this.indexes.length - 1;
        String eoNames = this.printCPIndex ? "" : ";";
        for (int i = 0; i <= lastIndex; ++i) {
            if (this.printCPIndex) {
                indexes.append("#").append(this.indexes[i]).append(i == lastIndex ? ";" : ", ");
            }
            names.append(this.pool.StringValue(this.indexes[i])).append(i == lastIndex ? eoNames : ", ");
        }
        this.printIndent(this.PadRight(this.token.parseKey(), this.getPrintAttributeKeyPadding()));
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.println(indexes.toString());
            } else {
                this.print(this.PadRight(indexes.toString(), this.getPrintAttributeCommentPadding())).println(" // " + names);
            }
        } else {
            this.println(names.toString());
        }
    }

    public void jasmPrintLong() {
        String name = this.token.parseKey();
        String locIndent = " ".repeat(name.length());
        int lastIndex = this.indexes.length - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.printIndent(this.PadRight(i == 0 ? name : locIndent, this.getPrintAttributeKeyPadding())).print("#%d".formatted(this.indexes[i])).println(i == lastIndex ? ";" : ",");
                    continue;
                }
                this.printIndent(this.PadRight(i == 0 ? name : locIndent, this.getPrintAttributeKeyPadding())).print(this.PadRight("#%d%s".formatted(this.indexes[i], i == lastIndex ? ";" : ","), this.getPrintAttributeCommentPadding())).println(" // %s".formatted(this.pool.StringValue(this.indexes[i])));
                continue;
            }
            this.printIndent(this.PadRight(i == 0 ? name : locIndent, this.getPrintAttributeKeyPadding())).print(this.pool.StringValue(this.indexes[i])).println(i == lastIndex ? ";" : ",");
        }
    }

    @Override
    protected void tablePrint() {
        this.jasmPrint();
    }
}

