/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.SyntaxError;
import org.openjdk.asmtools.common.inputs.FileInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.structure.CFVersion;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Container;
import org.openjdk.asmtools.jdis.EnclosingMethodData;
import org.openjdk.asmtools.jdis.FieldData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.InnerClassData;
import org.openjdk.asmtools.jdis.LoadableDescriptorsData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.ModuleData;
import org.openjdk.asmtools.jdis.NestHostData;
import org.openjdk.asmtools.jdis.NestMembersData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.PermittedSubclassesData;
import org.openjdk.asmtools.jdis.Printable;
import org.openjdk.asmtools.jdis.RecordData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.SourceDebugExtensionData;
import org.openjdk.asmtools.jdis.SourceFileData;
import org.openjdk.asmtools.jdis.TextLines;
import org.openjdk.asmtools.jdis.notations.Type;

public class ClassData
extends MemberData<ClassData> {
    private boolean alreadyPrinted = false;
    private boolean canBePrinted = false;
    protected CFVersion cfVersion = new CFVersion();
    protected int this_cpx;
    protected int super_cpx;
    protected String className = "";
    protected String packageName = "";
    protected String classShortName = "";
    protected int[] interfaces;
    protected Container<FieldData, ClassData> fields;
    protected Container<MethodData, ClassData> methods;
    private int totalAttributes = 0;
    protected SourceFileData sourceFileData;
    protected Container<InnerClassData, ClassData> innerClasses;
    protected EnclosingMethodData enclosingMethodData;
    protected RecordData recordData;
    protected Container<BootstrapMethodData, ClassData> bootstrapMethods;
    protected ModuleData moduleData;
    protected NestHostData nestHost;
    protected NestMembersData nestMembers;
    protected PermittedSubclassesData permittedSubclassesData;
    protected SourceDebugExtensionData sourceDebugExtensionData;
    protected LoadableDescriptorsData loadableDescriptorsData;
    private TextLines sourceLines = null;
    private Path classFile = null;

    public <E extends Environment<DecompilerLogger>> ClassData(E environment) {
        super(environment);
        this.memberType = "ClassData";
        this.environment = environment;
        environment.traceln("printOptions=" + Options.asShortString(), new Object[0]);
        this.pool = new ConstantPool(this);
        super.init(this);
    }

    public boolean isDetailedOutput() {
        return this.detailedOutput || this.extraDetailedOutput;
    }

    protected void readFields(DataInputStream in) throws IOException {
        int nFields = in.readUnsignedShort();
        this.environment.traceln("fields=#" + nFields, new Object[0]);
        this.fields = new Container<FieldData, ClassData>(this, FieldData.class, nFields);
        for (int k = 0; k < nFields; ++k) {
            FieldData field = new FieldData(this);
            this.environment.traceln("  FieldData: #" + k, new Object[0]);
            field.read(in);
            this.fields.add(field);
        }
    }

    protected void readMethods(DataInputStream in) throws IOException {
        int nMethods = in.readUnsignedShort();
        this.environment.traceln("methods=#" + nMethods, new Object[0]);
        this.methods = new Container<MethodData, ClassData>(this, MethodData.class, nMethods);
        for (int k = 0; k < nMethods; ++k) {
            MethodData method = new MethodData(this);
            this.environment.traceln("MethodData: #" + k, new Object[0]);
            method.read(in);
            this.methods.add(method);
        }
    }

    protected void readInterfaces(DataInputStream in) throws IOException {
        int nInterfaces = in.readUnsignedShort();
        this.environment.traceln("interfaces=#" + nInterfaces, new Object[0]);
        this.interfaces = new int[nInterfaces];
        for (int i = 0; i < nInterfaces; ++i) {
            short interfaceCpx = in.readShort();
            this.environment.traceln("  InterfaceCpx[" + i + "]=" + interfaceCpx, new Object[0]);
            this.interfaces[i] = interfaceCpx;
        }
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        boolean handled = true;
        ++this.totalAttributes;
        switch (attributeTag) {
            case ATT_Signature: {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", "Signature", "ClassFile");
                }
                this.signature = new SignatureData(this).read(in, attributeLength);
                break;
            }
            case ATT_SourceFile: {
                if (this.sourceFileData != null) {
                    this.environment.warning("warn.one.attribute.required", "SourceFile", "ClassFile");
                }
                this.sourceFileData = (SourceFileData)new SourceFileData(this).read(in, attributeLength);
                break;
            }
            case ATT_EnclosingMethod: {
                if (this.enclosingMethodData != null) {
                    this.environment.warning("warn.one.attribute.required", "EnclosingMethod", "ClassFile");
                }
                this.enclosingMethodData = (EnclosingMethodData)new EnclosingMethodData(this).read(in, attributeLength);
                break;
            }
            case ATT_SourceDebugExtension: {
                this.sourceDebugExtensionData = new SourceDebugExtensionData(this).read(in, attributeLength);
                break;
            }
            case ATT_InnerClasses: {
                int count = in.readUnsignedShort();
                if (2 + count * 8 != attributeLength) {
                    if (this.bestEffort) {
                        this.environment.getLogger().error("err.invalid.attribute.length", "InnerClasses_attribute", attributeLength);
                    } else {
                        throw new FormatError(this.environment.getLogger(), "err.invalid.attribute.length", new Object[]{"InnerClasses_attribute", attributeLength});
                    }
                }
                this.innerClasses = new Container<InnerClassData, ClassData>(this, InnerClassData.class, count).setHasSize(!this.isTableOutput() && !this.skipComments && !this.tableFormat);
                this.innerClasses.setCommentOffset(this.getCommentOffset());
                for (int j = 0; j < count; ++j) {
                    InnerClassData innerClass = new InnerClassData(this, this.innerClasses);
                    innerClass.read(in);
                    this.innerClasses.add(innerClass);
                }
                break;
            }
            case ATT_BootstrapMethods: {
                int count = in.readUnsignedShort();
                this.bootstrapMethods = new Container<BootstrapMethodData, ClassData>(this, BootstrapMethodData.class, count);
                this.bootstrapMethods.setCommentOffset(this.getCommentOffset());
                for (int j = 0; j < count; ++j) {
                    BootstrapMethodData bsmData = new BootstrapMethodData(this, this.bootstrapMethods);
                    bsmData.read(in);
                    this.bootstrapMethods.add(bsmData);
                }
                break;
            }
            case ATT_Module: {
                this.moduleData = new ModuleData(this);
                this.moduleData.read(in);
                break;
            }
            case ATT_NestHost: {
                this.nestHost = (NestHostData)new NestHostData(this).read(in, attributeLength);
                break;
            }
            case ATT_NestMembers: {
                this.nestMembers = new NestMembersData(this).read(in, attributeLength);
                break;
            }
            case ATT_Record: {
                this.recordData = new RecordData(this).read(in);
                break;
            }
            case ATT_PermittedSubclasses: {
                this.permittedSubclassesData = new PermittedSubclassesData(this).read(in, attributeLength);
                break;
            }
            case ATT_LoadableDescriptors: {
                this.loadableDescriptorsData = new LoadableDescriptorsData(this).read(in, attributeLength);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in, Path src) throws IOException {
        this.classFile = src;
        try {
            int magic = in.readInt();
            if (magic != -889275714) {
                this.environment.warning("warn.wrong.magic", HexUtils.toHex(-889275714), HexUtils.toHex(magic));
            }
            this.cfVersion.setMinorVersion(in.readUnsignedShort());
            this.cfVersion.setMajorVersion(in.readUnsignedShort());
            this.pool.read(in).InitializePrintData();
            this.access = in.readUnsignedShort();
            this.this_cpx = in.readUnsignedShort();
            this.super_cpx = in.readUnsignedShort();
            this.environment.traceln("0x%04X [ %s] this_cpx=%d super_cpx=%d", this.access, EModifier.asNames(this.access, EModifier.isModule(this.access) ? ClassFileContext.CLASS : ClassFileContext.MODULE), this.this_cpx, this.super_cpx);
            this.readInterfaces(in);
            this.readFields(in);
            this.readMethods(in);
            this.readAttributes(in);
            this.initClassNames(this.this_cpx);
            this.environment.traceln("\n<< Reading is done >>", new Object[0]);
            if (this.cfVersion.isValueObjectContext()) {
                EModifier.setGlobalContext(ClassFileContext.VALUE_OBJECTS);
            }
        }
        catch (EOFException eofException) {
            this.environment.error("err.eof", new Object[0]);
        }
    }

    private void initClassNames(int this_cpx) {
        this.className = this.pool.getClassName(this_cpx);
        int idx = this.className.lastIndexOf(47);
        if (idx != -1) {
            this.packageName = this.className.substring(0, idx);
            this.classShortName = this.className.substring(idx + 1);
        } else {
            this.classShortName = this.className;
        }
        if (this.sourceFileData != null) {
            this.sourceFileData.getName();
        }
    }

    public boolean hasPackage() {
        return !this.packageName.isEmpty();
    }

    public String getClassName() {
        return this.className;
    }

    public String getSrcLine(int lineNum) {
        String line;
        if (this.sourceLines == null) {
            return null;
        }
        try {
            line = this.sourceLines.getLine(lineNum);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            line = String.format("Line number %d is out of bounds", lineNum);
        }
        return line;
    }

    @Override
    protected <T extends AnnotationData> void printAnnotations(List<T> ... annotationLists) throws IOException {
        for (List<T> list : annotationLists) {
            if (list == null) continue;
            for (AnnotationData annotation : list) {
                annotation.initIndent(0);
                annotation.print();
                this.println();
            }
        }
    }

    public void postPrint() {
        if (!this.alreadyPrinted && this.canBePrinted) {
            try {
                this.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.environment.getToolOutput().finishClass(this.className);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.environment.getOutputs().flush();
    }

    @Override
    public void print() throws IOException {
        List<IOException> issues;
        if (COMPILATION_UNIT.get(this.className, this.access) == COMPILATION_UNIT.MODULE_INFO) {
            this.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
            if (this.moduleData == null) {
                this.moduleData = new ModuleData(this);
            }
            this.print(this.moduleData.getModuleHeader(String.format("version %s", this.cfVersion.asString())));
            this.println();
            this.println("{");
            if (this.printConstantPool) {
                this.pool.print();
            }
            this.canBePrinted = true;
            this.moduleData.print();
            this.print(String.format("} // end of module %s", this.moduleData.getModuleName()));
            if (this.moduleData.getModuleVersion() != null) {
                this.print("@" + this.moduleData.getModuleVersion());
            }
            this.println();
            this.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
            this.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
            if (this.hasPackage()) {
                this.println(String.format("package %s version %s;", this.packageName, this.cfVersion.asString()));
            }
        } else {
            String sourceName;
            this.printClassIntroduction();
            this.canBePrinted = true;
            if (this.printSourceLines && this.sourceFileData != null && (sourceName = this.sourceFileData.calculateName()) != null) {
                this.sourceLines = new TextLines(this.classFile.getParent(), sourceName);
            }
            List printableAttributes = this.getListOfPrintableAttributes(new Indenter[]{this.signature, this.sourceFileData, this.enclosingMethodData, this.sourceDebugExtensionData, this.recordData, this.nestHost, this.innerClasses, this.nestMembers, this.permittedSubclassesData, this.loadableDescriptorsData, this.bootstrapMethods});
            int commentOffset = this.getCommentOffset();
            if (this.printMemberDataList(this.fields, commentOffset) && this.isPrintable(new Container[]{this.methods}) && !printableAttributes.isEmpty()) {
                this.println();
            }
            this.setCommentOffset(commentOffset -= this.getIndentSize());
            if (this.printMemberDataList(this.methods, commentOffset) && !printableAttributes.isEmpty()) {
                this.println();
            }
            this.printAttributes(printableAttributes, commentOffset);
            if (this.skipComments) {
                this.println("}");
            } else {
                this.println(String.format("} // end Class %s%s", this.className, this.sourceFileData != null ? " compiled from \"" + this.sourceFileData.calculateName() + "\"" : ""));
            }
            this.alreadyPrinted = true;
        }
        if (!(issues = this.pool.getIssues()).isEmpty()) {
            for (IOException ioe : issues) {
                this.environment.error(ioe);
            }
            throw new SyntaxError();
        }
    }

    protected void printClassIntroduction() throws IOException {
        this.printSysInfo();
        if (this.hasPackage()) {
            this.println(String.format("package %s;%n", this.packageName));
        }
        this.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
        this.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
        this.printJasmClassDeclaration();
        this.println("{");
        int thisCommentOffset = this.pool.getCommentOffset();
        if (this.printConstantPool) {
            this.pool.print();
            this.setCommentOffset(thisCommentOffset);
        }
        if (this.extraDetailedOutput && !this.dropClasses) {
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.printIndentLn("this_class:  #%d;".formatted(this.this_cpx), thisCommentOffset);
                    this.printIndentLn("super_class: #%d;".formatted(this.super_cpx), thisCommentOffset);
                } else {
                    this.printIndent(this.PadRight("this_class:  #%d;".formatted(this.this_cpx), thisCommentOffset -= this.getIndentSize())).println(" // " + this.pool.getClassName(this.this_cpx, cpx -> "invalid index into the constant_pool table"));
                    this.printIndent(this.PadRight("super_class: #%d;".formatted(this.super_cpx), thisCommentOffset)).println(" // " + this.pool.getClassName(this.super_cpx, cpx -> "invalid index into the constant_pool table"));
                }
            } else {
                this.printIndentLn("this_class:  %s;".formatted(this.pool.getClassName(this.this_cpx, cpx -> "invalid index into the constant_pool table")));
                this.printIndentLn("super_class: %s;".formatted(this.pool.getClassName(this.super_cpx, cpx -> "invalid index into the constant_pool table")));
            }
            this.println();
        }
    }

    @Override
    protected void printSysInfo() {
        if (this.sysInfo) {
            byte[] digest;
            Date lm;
            ToolInput toolInput = this.environment.getToolInput();
            String thisClassName = this.pool.getJavaClassName(this.this_cpx, "<invalid this_cpx #%d>");
            boolean isClass = !EModifier.isInterface(this.access);
            String prefix = " *  ";
            this.println("/**");
            if (toolInput instanceof FileInput) {
                this.println(prefix + "Classfile " + this.classFile.toAbsolutePath());
                lm = new Date(this.classFile.toFile().lastModified());
            } else {
                String name = this.classFile.toString();
                this.println(prefix + "Classfile " + name.substring(name.lastIndexOf(47) + 1));
                lm = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            DateFormat df = DateFormat.getDateInstance();
            int length = toolInput.getSize();
            if (length > 0) {
                this.println(prefix + INDENT_STRING + "Last modified %s; size %d bytes", df.format(lm), length);
            } else {
                this.println(prefix + INDENT_STRING + "Last modified %s", df.format(lm));
            }
            MessageDigest msd = toolInput.getMessageDigest();
            if (msd != null && (digest = msd.digest()) != null) {
                StringBuilder sb = new StringBuilder();
                for (byte b : digest) {
                    sb.append(String.format("%02x", b));
                }
                this.println(prefix + INDENT_STRING + msd.getAlgorithm() + " checksum " + sb);
            }
            if (this.sourceFileData != null) {
                this.println(prefix + INDENT_STRING + "Compiled from \"%s\"".formatted(this.sourceFileData.calculateName()));
            }
            if (isClass) {
                this.print(prefix + EModifier.asKeywords(this.access & ~EModifier.ACC_SUPER.getFlag(), ClassFileContext.CLASS) + "class " + thisClassName);
            } else {
                this.print(prefix + EModifier.asKeywords(this.access & ~EModifier.ACC_ABSTRACT.getFlag() & ~EModifier.ACC_SUPER.getFlag(), ClassFileContext.CLASS) + "interface " + thisClassName);
            }
            if (this.signature == null) {
                String superClassName;
                if (isClass && this.super_cpx != 0 && !(superClassName = this.pool.getJavaClassName(this.this_cpx, "<invalid super_cpx #%d>")).equals("java.lang.Object")) {
                    this.print(" extends " + superClassName);
                }
                for (int i = 0; i < this.interfaces.length; ++i) {
                    this.print(i == 0 ? (isClass ? " implements " : " extends ") : ",");
                    this.print(this.pool.getJavaClassName(this.interfaces[i], "<invalid interface_cpx #%d>"));
                }
                this.println();
            } else {
                Type signType = this.signature.getSignatureType();
                String sign = this.signature.getJavaSignature();
                if (signType instanceof Type.ClassSigType) {
                    this.print(sign);
                } else if (!signType.isObject()) {
                    this.print(" extends " + sign);
                }
                this.println();
            }
            this.println(prefix + INDENT_STRING + "minor version: " + this.cfVersion.minor_version());
            this.println(prefix + INDENT_STRING + "major version: " + this.cfVersion.major_version());
            this.println(prefix + INDENT_STRING + "flags: (0x%04x) %s".formatted(this.access, EModifier.asNames(this.access, ClassFileContext.CLASS)));
            this.println(prefix + INDENT_STRING + "this_class:  %s".formatted(this.pool.getClassName(this.this_cpx, cpx -> "invalid index into the constant_pool table")));
            this.println(prefix + INDENT_STRING + "super_class: %s".formatted(this.pool.getClassName(this.super_cpx, cpx -> "invalid index into the constant_pool table")));
            this.println(prefix + INDENT_STRING + "interfaces: %d, fields: %d, methods: %d, attributes: %d", this.interfaces.length, this.fields.size(), this.methods.size(), this.totalAttributes);
            this.println(" */");
        }
    }

    protected void printJasmClassDeclaration() {
        Pair<String, String> signInfo;
        String shortClassName = this.pool.inRange(this.this_cpx) ? this.pool.getShortClassName(this.this_cpx, this.packageName) : "?? invalid index";
        Pair<String, String> pair = signInfo = this.signature != null ? this.signature.getJasmPrintInfo(i -> this.pool.inRange((int)i)) : new Pair<String, String>("", "");
        if (EModifier.isInterface(this.access)) {
            this.print(EModifier.asKeywords(this.access & ~EModifier.ACC_ABSTRACT.getFlag(), ClassFileContext.CLASS));
            this.print(this.printCPIndex ? (this.skipComments ? String.format("interface #%d%s", this.this_cpx, signInfo.first) : String.format("interface #%d%s /* %s%s */", this.this_cpx, signInfo.first, shortClassName, signInfo.second)) : String.format("interface %s", shortClassName, signInfo.second));
        } else {
            this.print(EModifier.asKeywords(this.access, ClassFileContext.CLASS) + this.getPseudoFlagsAsString());
            this.print(this.printCPIndex ? (this.skipComments ? String.format("class #%d%s", this.this_cpx, signInfo.first) : String.format("class #%d%s /* %s%s */", this.this_cpx, signInfo.first, shortClassName, signInfo.second)) : String.format("class %s%s", shortClassName, signInfo.second));
            if (this.this_cpx < this.pool.size() && this.this_cpx > 0) {
                if (!this.pool.getClassName(this.super_cpx).equals("java/lang/Object")) {
                    this.print(this.printCPIndex ? (this.skipComments ? String.format(" extends #%d", this.super_cpx) : String.format(" extends #%d /* %s */", this.super_cpx, this.pool.getShortClassName(this.super_cpx, this.packageName))) : String.format(" extends %s", this.pool.getShortClassName(this.super_cpx, this.packageName)));
                }
            } else {
                this.print(this.printCPIndex ? (this.skipComments ? String.format(" extends #%d", this.super_cpx) : String.format(" extends #%d /* ?? invalid index */", this.super_cpx)) : " extends ??");
            }
        }
        int numInterfaces = this.interfaces.length;
        if (numInterfaces > 0) {
            String statement;
            String sNames = Arrays.stream(this.interfaces).mapToObj(cpx -> this.pool.getShortClassName(cpx, this.packageName)).collect(Collectors.joining(", "));
            if (this.printCPIndex) {
                String sIndexes = Arrays.stream(this.interfaces).mapToObj(cpx -> String.format("#%d", cpx)).collect(Collectors.joining(", "));
                statement = this.skipComments ? String.format("%simplements %s", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", sIndexes) : String.format("%simplements %s /* %s */", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", sIndexes, sNames);
            } else {
                statement = String.format("%simplements %s", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", sNames);
            }
            this.print(statement);
        }
        this.println("%sversion %s", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", this.cfVersion.asString());
    }

    private <P extends Printable> List<P> getListOfPrintableAttributes(P ... attributes) {
        return Arrays.stream(attributes).filter(a -> this.isPrintable(new Printable[]{a})).toList();
    }

    private <P extends Printable> boolean isPrintable(P ... attributes) {
        return Arrays.stream(attributes).anyMatch(attribute -> attribute != null && attribute.isPrintable());
    }

    private <P extends Printable> void printAttributes(List<P> attributeList, int commentOffset) throws IOException {
        int len = attributeList.size();
        boolean printed = false;
        for (int i = 0; i < len; ++i) {
            Printable attribute = (Printable)attributeList.get(i);
            if (this.isPrintable(new Printable[]{attribute})) {
                if (Indenter.class.isAssignableFrom(attribute.getClass())) {
                    ((Indenter)attribute).setCommentOffset(commentOffset);
                }
                attribute.print();
                printed = true;
            }
            if (!printed || i + 1 >= len) continue;
            this.println();
            printed = false;
        }
    }

    private boolean printMemberDataList(Container<? extends MemberData<ClassData>, ClassData> list, int commentOffset) throws IOException {
        if (list != null && list.size() > 0) {
            list.setCommentOffset(commentOffset).print();
            return true;
        }
        return false;
    }

    public static enum COMPILATION_UNIT {
        MODULE_INFO,
        PACKAGE_INFO,
        CLASS_UNIT;


        public static COMPILATION_UNIT get(String className, int access) {
            if (className.endsWith("module-info") || EModifier.isModule(access)) {
                return MODULE_INFO;
            }
            if (className.endsWith("package-info") && EModifier.isInterface(access)) {
                return PACKAGE_INFO;
            }
            return CLASS_UNIT;
        }
    }
}

