/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Container;
import org.openjdk.asmtools.jdis.InstructionAttr;
import org.openjdk.asmtools.jdis.LineNumberData;
import org.openjdk.asmtools.jdis.LocalVariableData;
import org.openjdk.asmtools.jdis.LocalVariableTypeData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.StackMapData;
import org.openjdk.asmtools.jdis.StackMapTable;
import org.openjdk.asmtools.jdis.TrapData;
import org.openjdk.asmtools.jdis.TypeAnnotationData;

public class CodeData
extends MemberData<MethodData> {
    private final HashMap<Integer, InstructionAttr> instructionAttrs = new HashMap();
    protected byte[] code;
    protected int max_stack;
    protected int max_locals;
    protected ArrayList<AttrData> attrs = new ArrayList(0);
    private ArrayList<TrapData> trap_table = new ArrayList(0);
    private Container<LineNumberData, CodeData> lineNumberTable;
    private Container<LocalVariableData, CodeData> localVariableTable;
    private Container<LocalVariableTypeData, CodeData> localVariableTypeTable;
    private StackMapTable stackMapTable;
    private boolean firstStackEntry = true;
    private ArrayList<TypeAnnotationData<MethodData>> visibleTypeAnnotations;
    private ArrayList<TypeAnnotationData<MethodData>> invisibleTypeAnnotations;
    private int instructionOffset;
    private int attributeOffset;

    public CodeData(MethodData data) {
        super(data);
        if (data.printProgramCounter) {
            this.attributeOffset = this.instructionOffset = 7;
        } else {
            this.instructionOffset = 7;
            this.attributeOffset = this.instructionOffset - this.getIndentStep();
        }
    }

    private static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    private int getByte(int pc) throws IndexOutOfBoundsException {
        if (pc < 0 || pc >= this.code.length) {
            throw new IndexOutOfBoundsException(this.environment.getInfo("err.out.of.range", pc));
        }
        return this.code[pc];
    }

    private int getUByte(int pc) throws IndexOutOfBoundsException {
        if (pc < 0 || pc >= this.code.length) {
            throw new IndexOutOfBoundsException(this.environment.getInfo("err.out.of.range", pc));
        }
        return this.code[pc] & 0xFF;
    }

    private int getShort(int pc) throws IndexOutOfBoundsException {
        if (pc < 0 || pc + 1 >= this.code.length) {
            throw new IndexOutOfBoundsException(this.environment.getInfo("err.out.of.range", pc));
        }
        return this.code[pc] << 8 | this.code[pc + 1] & 0xFF;
    }

    private int getUShort(int pc) throws IndexOutOfBoundsException {
        if (pc < 0 || pc + 1 >= this.code.length) {
            throw new IndexOutOfBoundsException(this.environment.getInfo("err.out.of.range", pc));
        }
        return (this.code[pc] << 8 | this.code[pc + 1] & 0xFF) & 0xFFFF;
    }

    private int getInt(int pc) throws IndexOutOfBoundsException {
        return this.getShort(pc) << 16 | this.getShort(pc + 2) & 0xFFFF;
    }

    protected InstructionAttr getInstructionAttribute(int pc) {
        Integer PC = pc;
        InstructionAttr res = this.instructionAttrs.get(PC);
        if (res == null) {
            res = new InstructionAttr((MethodData)this.data);
            res.setTheSame(this).incIndent();
            this.instructionAttrs.put(PC, res);
        }
        return res;
    }

    protected InstructionAttr getLastInstruction() {
        return this.instructionAttrs.get(Collections.max(this.instructionAttrs.keySet()));
    }

    protected InstructionAttr getFirstInstruction() {
        return this.instructionAttrs.get(Collections.min(this.instructionAttrs.keySet()));
    }

    private Container<LineNumberData, CodeData> readLineNumberTable(DataInputStream in, boolean ignoreMemorization) throws IOException {
        int len = in.readInt();
        int nLines = in.readUnsignedShort();
        Container<LineNumberData, CodeData> table = ignoreMemorization ? null : new Container<LineNumberData, CodeData>(this, LineNumberData.class, nLines);
        this.environment.traceln("CodeAttr:  LineNumberTable[%d] length=%d", nLines, len);
        for (int l = 0; l < nLines; ++l) {
            LineNumberData data = new LineNumberData(in, (MethodData)this.data);
            if (ignoreMemorization) continue;
            table.add(data);
        }
        return table;
    }

    private Container<LocalVariableData, CodeData> readLocalVariableTable(DataInputStream in, boolean ignoreMemorization) throws IOException {
        int len = in.readInt();
        int nLines = in.readUnsignedShort();
        Container<LocalVariableData, CodeData> table = ignoreMemorization ? null : new Container<LocalVariableData, CodeData>(this, LocalVariableData.class, nLines);
        this.environment.traceln("CodeAttr:  LocalVariableTable[%d] length=%d", nLines, len);
        for (int l = 0; l < nLines; ++l) {
            LocalVariableData<MemberData> data = new LocalVariableData<MemberData>(this.owner, in, (MethodData)this.data);
            if (ignoreMemorization) continue;
            table.add(data);
        }
        return table;
    }

    private Container<LocalVariableTypeData, CodeData> readLocalVariableTypeTable(DataInputStream in, boolean ignoreMemorization) throws IOException {
        int len = in.readInt();
        int nLines = in.readUnsignedShort();
        Container<LocalVariableTypeData, CodeData> table = ignoreMemorization ? null : new Container<LocalVariableTypeData, CodeData>(this, LocalVariableTypeData.class, nLines);
        this.environment.traceln("CodeAttr:  LocalVariableTypeTable[%d] length=%d", nLines, len);
        for (int l = 0; l < nLines; ++l) {
            LocalVariableTypeData<MemberData> data = new LocalVariableTypeData<MemberData>(this.owner, in, (MethodData)this.data);
            if (ignoreMemorization) continue;
            table.add(data);
        }
        return table;
    }

    private void readTrapTable(DataInputStream in) throws IOException {
        int trap_table_len = in.readUnsignedShort();
        this.environment.traceln("CodeAttr:  TrapTable[%d]", trap_table_len);
        this.trap_table = new ArrayList(trap_table_len);
        for (int l = 0; l < trap_table_len; ++l) {
            this.trap_table.add(new TrapData(in, l));
        }
    }

    private void readStackMapEntity(EAttribute attribute, DataInputStream in) throws IOException {
        int len = in.readInt();
        int stackMapLength = in.readUnsignedShort();
        this.stackMapTable = new StackMapTable(attribute, this, stackMapLength);
        this.firstStackEntry = true;
        this.environment.traceln(() -> "CodeAttr:  %s: attrLength=%d num=%d".formatted(attribute.name(), len, stackMapLength));
        int prevFrame_pc = 0;
        int idx = 0;
        boolean nextIsWrapped = false;
        int wrapLevel = 0;
        while (idx < stackMapLength) {
            StackMapData stackMapData = switch (attribute) {
                case EAttribute.ATT_StackMap -> new StackMapData(this, in);
                case EAttribute.ATT_StackMapTable -> new StackMapData(this.calculateFirstPosition(idx), prevFrame_pc, this, in);
                default -> throw new IllegalStateException("Unexpected value: " + attribute);
            };
            prevFrame_pc = stackMapData.getFramePC();
            if (stackMapData.getStackEntryType() == StackMap.EntryType.EARLY_LARVAL) {
                stackMapData.isWrapped = nextIsWrapped;
                stackMapData.wrapLevel = wrapLevel++;
                this.stackMapTable.add(stackMapData, true);
                nextIsWrapped = true;
                continue;
            }
            stackMapData.isWrapped = nextIsWrapped;
            stackMapData.wrapLevel = wrapLevel;
            this.stackMapTable.add(stackMapData, false);
            nextIsWrapped = false;
            wrapLevel = 0;
            ++idx;
        }
    }

    private boolean calculateFirstPosition(int index) {
        if (this.firstStackEntry) {
            if (index == 0 || this.stackMapTable.wrappers.get(index - 1).booleanValue()) {
                return true;
            }
            this.firstStackEntry = false;
        }
        return false;
    }

    private void readTypeAnnotations(DataInputStream in, boolean isInvisible) throws IOException {
        int attrLength = in.readInt();
        int count = in.readShort();
        ArrayList<TypeAnnotationData<MethodData>> tannots = new ArrayList<TypeAnnotationData<MethodData>>(count);
        this.environment.traceln("CodeAttr:   Runtime%sisibleTypeAnnotation: attrLength=%d num= %d", isInvisible ? "Inv" : "V", attrLength, count);
        for (int index = 0; index < count; ++index) {
            TypeAnnotationData<MethodData> tannot = new TypeAnnotationData<MethodData>((MethodData)this.data, isInvisible);
            tannot.read(in);
            tannots.add(tannot);
        }
        if (isInvisible) {
            this.invisibleTypeAnnotations = tannots;
        } else {
            this.visibleTypeAnnotations = tannots;
        }
    }

    public void read(DataInputStream in, int codeAttrLength) throws IOException {
        this.max_stack = in.readUnsignedShort();
        this.max_locals = in.readUnsignedShort();
        int codelen = in.readInt();
        this.environment.traceln("CodeAttr:  CodeLength=%d FullLength=%d max_stack=%d max_locals=%d", codelen, codeAttrLength, this.max_stack, this.max_locals);
        this.code = new byte[codelen];
        in.read(this.code, 0, codelen);
        this.readTrapTable(in);
        int nattr = in.readUnsignedShort();
        this.environment.traceln("CodeAttr: add.attr: %d", nattr);
        block7: for (int k = 0; k < nattr; ++k) {
            int name_cpx = in.readUnsignedShort();
            ConstantPool.Constant name_const = this.pool.getConst(name_cpx);
            if (name_const == null || name_const.tag != ConstantPool.TAG.CONSTANT_UTF8) continue;
            String attrName = this.pool.getString(name_cpx, index -> "#" + index);
            this.environment.traceln("CodeAttr:  attr: " + attrName, new Object[0]);
            EAttribute attrTag = EAttribute.get(attrName);
            switch (attrTag) {
                case ATT_LineNumberTable: {
                    this.lineNumberTable = this.readLineNumberTable(in, !this.printLineNumber);
                    continue block7;
                }
                case ATT_LocalVariableTable: {
                    this.localVariableTable = this.readLocalVariableTable(in, !this.printLocalVariables);
                    continue block7;
                }
                case ATT_LocalVariableTypeTable: {
                    this.localVariableTypeTable = this.readLocalVariableTypeTable(in, !this.printLocalVariableTypes);
                    continue block7;
                }
                case ATT_StackMap: 
                case ATT_StackMapTable: {
                    this.readStackMapEntity(attrTag, in);
                    continue block7;
                }
                case ATT_RuntimeVisibleTypeAnnotations: 
                case ATT_RuntimeInvisibleTypeAnnotations: {
                    this.readTypeAnnotations(in, attrTag == EAttribute.ATT_RuntimeInvisibleTypeAnnotations);
                    continue block7;
                }
                default: {
                    AttrData attr = new AttrData(this.environment, attrTag);
                    int attrLen = in.readInt();
                    attr.read(name_cpx, attrLen, in);
                    this.attrs.add(attr);
                }
            }
        }
    }

    private int checkForLabelRef(int pc) {
        int opc = this.getUByte(pc);
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(opc);
        try {
            if (opcode == null) {
                this.getInstructionAttribute((int)pc).referred = true;
                return 1;
            }
            switch (opcode) {
                case opc_tableswitch: {
                    try {
                        int tb = CodeData.align(pc + 1);
                        int default_skip = this.getInt(tb);
                        int low = this.getInt(tb + 4);
                        int high = this.getInt(tb + 8);
                        int count = high - low;
                        for (int i = 0; i <= count; ++i) {
                            this.getInstructionAttribute((int)(pc + this.getInt((int)(tb + 12 + 4 * i)))).referred = true;
                        }
                        this.getInstructionAttribute((int)(default_skip + pc)).referred = true;
                        return tb - pc + 16 + count * 4;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.environment.error(e);
                        this.getInstructionAttribute((int)pc).referred = true;
                        return 1;
                    }
                }
                case opc_lookupswitch: {
                    try {
                        int tb = CodeData.align(pc + 1);
                        int default_skip = this.getInt(tb);
                        int npairs = this.getInt(tb + 4);
                        for (int i = 1; i <= npairs; ++i) {
                            this.getInstructionAttribute((int)(pc + this.getInt((int)(tb + 4 + i * 8)))).referred = true;
                        }
                        this.getInstructionAttribute((int)(default_skip + pc)).referred = true;
                        return tb - pc + (npairs + 1) * 8;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.environment.error(e);
                        this.getInstructionAttribute((int)pc).referred = true;
                        return 1;
                    }
                }
                case opc_jsr: 
                case opc_goto: 
                case opc_ifeq: 
                case opc_ifge: 
                case opc_ifgt: 
                case opc_ifle: 
                case opc_iflt: 
                case opc_ifne: 
                case opc_if_icmpeq: 
                case opc_if_icmpne: 
                case opc_if_icmpge: 
                case opc_if_icmpgt: 
                case opc_if_icmple: 
                case opc_if_icmplt: 
                case opc_if_acmpeq: 
                case opc_if_acmpne: 
                case opc_ifnull: 
                case opc_ifnonnull: {
                    try {
                        this.getInstructionAttribute((int)(pc + this.getShort((int)(pc + 1)))).referred = true;
                        return 3;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.environment.error(e);
                        this.getInstructionAttribute((int)pc).referred = true;
                        return 1;
                    }
                }
                case opc_jsr_w: 
                case opc_goto_w: {
                    this.getInstructionAttribute((int)(pc + this.getInt((int)(pc + 1)))).referred = true;
                    return 5;
                }
                case opc_wide: 
                case opc_nonpriv: 
                case opc_priv: {
                    int opc2 = (opcode.value() << 8) + this.getUByte(pc + 1);
                    opcode = OpcodeTables.opcode(opc2);
                }
            }
            if (opcode != null) {
                int opclen = opcode.length();
                return opclen == 0 ? 1 : opclen;
            }
            return 1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    private void loadLabelTable() {
        for (int pc = 0; pc < this.code.length; pc += this.checkForLabelRef(pc)) {
        }
    }

    private void loadLineNumTable() {
        for (LineNumberData entry : this.lineNumberTable) {
            this.getInstructionAttribute((int)entry.start_pc).lineNum = entry.line_number;
        }
    }

    private void loadStackMap() {
        ArrayList<StackMapData> wrappers = null;
        boolean firstWrapper = true;
        for (int i = 0; i < this.stackMapTable.size(); ++i) {
            StackMapData entry = (StackMapData)this.stackMapTable.get(i);
            if (this.stackMapTable.wrappers.get(i).booleanValue()) {
                if (wrappers == null) {
                    wrappers = new ArrayList<StackMapData>();
                }
                wrappers.add(entry);
                continue;
            }
            firstWrapper = false;
            InstructionAttr instr = this.getInstructionAttribute(entry.frame_pc);
            instr.stackMapEntry = entry;
            instr.stackMapWrappers = wrappers;
            wrappers = null;
        }
        if (wrappers != null) {
            InstructionAttr instr = firstWrapper ? this.getFirstInstruction() : this.getLastInstruction();
            instr.stackMapWrappers = wrappers;
        }
    }

    private void loadLocalVariableTable() {
        for (LocalVariableData entry : this.localVariableTable) {
            this.getInstructionAttribute(entry.start_pc).addVar(entry);
            this.getInstructionAttribute(entry.start_pc + entry.length).addEndVar(entry);
        }
    }

    private void loadLocalVariableTypeTable() {
        for (LocalVariableTypeData entry : this.localVariableTypeTable) {
            this.getInstructionAttribute(entry.start_pc).addType(entry);
            this.getInstructionAttribute(entry.start_pc + entry.length).addEndType(entry);
        }
    }

    private void loadTrapTable() {
        for (TrapData entry : this.trap_table) {
            this.getInstructionAttribute(entry.start_pc).addTrap(entry);
            this.getInstructionAttribute(entry.end_pc).addEndTrap(entry);
            this.getInstructionAttribute(entry.handler_pc).add_handler(entry);
        }
    }

    private int printInstrLn(int pc, int shift) {
        int opc = this.getUByte(pc);
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(opc);
        if (opcode == null) {
            this.print(this.PadRight("bytecode", 18)).println((Serializable)(this.printHEX ? HexUtils.toHex(opc) : Integer.valueOf(opc)) + ";");
            return 1;
        }
        switch (opcode) {
            case opc_nonpriv: 
            case opc_priv: {
                int count = 1;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    int opc2 = this.getUByte(pc + 1);
                    int finalopc = (opc << 8) + opc2;
                    OpcodeTables.Opcode opcode2 = OpcodeTables.opcode(finalopc);
                    if (opcode2 == null) {
                        this.print(this.PadRight(opcode.parseKey(), 18)).println((Serializable)(this.printHEX ? HexUtils.toHex(opc2) : Integer.valueOf(opc2)) + ";");
                    } else {
                        this.println(opcode2.parseKey() + ";");
                    }
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 2;
            }
            case opc_wide: {
                int count = 1;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() != count) {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                    return 1;
                }
                int opc2 = this.getUByte(pc + 1);
                int finalopcwide = (opc << 8) + opc2;
                OpcodeTables.Opcode opcode2 = OpcodeTables.opcode(finalopcwide);
                if (opcode2 == null) {
                    this.print(this.PadRight(OpcodeTables.Opcode.opc_bytecode.parseKey(), 18)).println(opcode.getPrintName() + ";");
                    return 1;
                }
                String mnem = opcode2.parseKey();
                if (opcode2 == OpcodeTables.Opcode.opc_iinc_w) {
                    count = 5;
                    validBytes = this.checkCodeBounds(pc, 5);
                    if (validBytes.size() == count) {
                        this.print(this.PadRight(mnem, 18));
                        this.println("%d, %d;", this.getUShort(pc + 2), this.getUShort(pc + 4));
                    } else {
                        this.printBytes(opcode.byteValue(), validBytes, shift);
                    }
                    return 6;
                }
                count = 3;
                validBytes = this.checkCodeBounds(pc, 3);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(mnem, 18)).println("%d;", this.getUShort(pc + 2));
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 4;
            }
        }
        String mnem = opcode.parseKey();
        if (mnem == null) {
            this.print(this.PadRight("bytecode", 18)).println(opcode + ";");
            return 1;
        }
        if (!opcode.isReservedOpcode()) {
            this.print(this.PadRight("bytecode", 18)).println(opcode + ";");
            return 1;
        }
        String operand = opcode.parseKey();
        switch (opcode) {
            case opc_aload: 
            case opc_astore: 
            case opc_fload: 
            case opc_fstore: 
            case opc_iload: 
            case opc_istore: 
            case opc_lload: 
            case opc_lstore: 
            case opc_dload: 
            case opc_dstore: 
            case opc_ret: {
                int count = 1;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(operand, 18)).println(this.getUByte(pc + 1) + ";");
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 2;
            }
            case opc_iinc: {
                int count = 2;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(operand, 18)).println("%d, %d;", this.getUByte(pc + 1), this.getByte(pc + 2));
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 3;
            }
            case opc_tableswitch: {
                boolean notPrinted = true;
                try {
                    int tb = CodeData.align(pc + 1);
                    int default_skip = this.getInt(tb);
                    int low = this.getInt(tb + 4);
                    int high = this.getInt(tb + 8);
                    int count = high - low;
                    this.printPadRight(String.format("%s { ", this.PadRight(operand, 17)), this.getCommentOffset());
                    this.println((String)(this.printCPIndex && !this.skipComments ? " // " + low + " to " + high : ""));
                    notPrinted = false;
                    for (int i = 0; i <= count; ++i) {
                        this.print(this.enlargedIndent(this.PadRight(String.format("%2d: ", i + low), 9), shift)).println(((MethodData)this.data).getLabelPrefix() + (pc + this.getInt(tb + 12 + 4 * i)) + ";");
                    }
                    this.print(this.enlargedIndent(this.PadRight("default: " + ((MethodData)this.data).getLabelPrefix() + (default_skip + pc), 17 - this.getIndentStep() - 2), shift)).println(" };");
                    return tb - pc + 16 + count * 4;
                }
                catch (IndexOutOfBoundsException e) {
                    if (notPrinted) {
                        this.println("%s { ".formatted(operand));
                        this.printIndentLn(this.enlargedIndent("BOGUS;", shift));
                        this.println(this.enlargedIndent(" };", shift));
                    } else {
                        this.println("BOGUS;").println(this.enlargedIndent(" };", shift));
                    }
                    this.environment.error(e);
                    return 1;
                }
            }
            case opc_lookupswitch: {
                boolean notPrinted = true;
                try {
                    int tb = CodeData.align(pc + 1);
                    int default_skip = this.getInt(tb);
                    int nPairs = this.getInt(tb + 4);
                    this.printPadRight(String.format("%s { ", this.PadRight(operand, 17)), this.getCommentOffset());
                    this.println((String)(this.printCPIndex && !this.skipComments ? " // " + nPairs : ""));
                    notPrinted = false;
                    Pair<Integer, Integer>[] lookupswitchPairs = this.getLookupswitchPairs(tb, nPairs);
                    int caseLength = Math.max(9, Arrays.stream(lookupswitchPairs).mapToInt(p -> String.valueOf(p.first).length()).max().orElse(0) + 2);
                    for (int i = 0; i < nPairs; ++i) {
                        this.print(this.enlargedIndent(this.PadRight(String.format("%2d:", lookupswitchPairs[i].first), caseLength), shift)).println(((MethodData)this.data).getLabelPrefix() + (pc + (Integer)lookupswitchPairs[i].second) + ";");
                    }
                    this.print(this.enlargedIndent(this.PadRight(this.PadRight("default: ", caseLength) + ((MethodData)this.data).getLabelPrefix() + (default_skip + pc), 17 - this.getIndentStep() - 2), shift)).println(" };");
                    return tb - pc + (nPairs + 1) * 8;
                }
                catch (IndexOutOfBoundsException e) {
                    if (notPrinted) {
                        this.println("%s { ".formatted(operand));
                    }
                    this.printIndentLn(this.enlargedIndent("BOGUS;", shift));
                    this.println(this.enlargedIndent(" };", shift));
                    this.environment.error(e);
                    return 1;
                }
            }
            case opc_newarray: {
                int count = 1;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    int tp = this.getUByte(pc + 1);
                    ClassFileConst.BasicType basicType = ClassFileConst.getBasicType(tp);
                    if (basicType == null) {
                        this.print(this.PadRight(operand, 18)).println("BOGUS TYPE: " + HexUtils.toHex(tp, 8) + ";");
                    } else {
                        this.print(this.PadRight(operand, 18)).println(basicType.printValue() + ";");
                    }
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 2;
            }
            case opc_ldc: 
            case opc_ldc_w: 
            case opc_ldc2_w: 
            case opc_invokedynamic: {
                try {
                    int index;
                    int opLength;
                    HashMap<Integer, List<Integer>> breakPositions = new HashMap();
                    if (opcode == OpcodeTables.Opcode.opc_ldc) {
                        opLength = 2;
                        breakPositions = LdwBreakPositions;
                        index = this.getUByte(pc + 1);
                    } else if (opcode == OpcodeTables.Opcode.opc_invokedynamic) {
                        opLength = 5;
                        breakPositions = InvokeDynamicBreakPositions;
                        index = this.getUShort(pc + 1);
                    } else {
                        opLength = 3;
                        breakPositions = LdwBreakPositions;
                        index = this.getUShort(pc + 1);
                    }
                    this.pool.setPrintTAG(true);
                    if (this.printCPIndex) {
                        if (this.skipComments) {
                            this.println(String.format("%s #%d;", this.PadRight(operand, 17), index));
                        } else {
                            this.printPadRight(String.format("%s #%d;", this.PadRight(operand, 17), index), this.getCommentOffset()).print(" // ");
                            this.println(this.formatOperandLine(this.pool.ConstantStrValue(index), this.getCommentOffset() + shift, " // ", breakPositions));
                        }
                    } else {
                        this.print(this.PadRight(operand, 18));
                        this.println(this.formatOperandLine(this.pool.ConstantStrValue(index), 17 + shift + 1, "", breakPositions) + ";");
                    }
                    this.pool.setPrintTAG(false);
                    return opLength;
                }
                catch (IndexOutOfBoundsException e) {
                    if (this.printCPIndex) {
                        if (this.skipComments) {
                            this.println(String.format("%s BOGUS;", this.PadRight(operand, 17)));
                        } else {
                            this.printPadRight(String.format("%s BOGUS;", this.PadRight(operand, 17)), this.getCommentOffset()).println(" // " + e.getMessage());
                        }
                    } else {
                        this.print(this.PadRight(operand, 18)).println("BOGUS;");
                    }
                    this.environment.error(e);
                    return 1;
                }
            }
            case opc_anewarray: 
            case opc_instanceof: 
            case opc_checkcast: 
            case opc_new: 
            case opc_putstatic: 
            case opc_getstatic: 
            case opc_putfield: 
            case opc_getfield: 
            case opc_invokevirtual: 
            case opc_invokespecial: 
            case opc_invokestatic: {
                int count = 2;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    int index = this.getUShort(pc + 1);
                    if (this.printCPIndex) {
                        if (this.skipComments) {
                            this.println(String.format("%s #%d;", this.PadRight(operand, 17), index));
                        } else {
                            this.printPadRight(String.format("%s #%d;", this.PadRight(operand, 17), index), this.getCommentOffset()).println(" // " + this.pool.ConstantStrValue(index));
                        }
                    } else {
                        this.print(this.PadRight(operand, 18));
                        this.println(this.pool.ConstantStrValue(index) + ";");
                    }
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 3;
            }
            case opc_multianewarray: 
            case opc_invokeinterface: {
                int count = opcode == OpcodeTables.Opcode.opc_multianewarray ? 3 : 4;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    int index = this.getUShort(pc + 1);
                    int dimensions = this.getUByte(pc + 3);
                    if (this.printCPIndex) {
                        if (this.skipComments) {
                            this.println(String.format("%s #%d, %d;", this.PadRight(operand, 17), index, dimensions));
                        } else {
                            this.printPadRight(String.format("%s #%d, %d;", this.PadRight(operand, 17), index, dimensions), this.getCommentOffset()).println(" // " + this.pool.ConstantStrValue(index));
                        }
                    } else {
                        this.print(this.PadRight(operand, 18));
                        this.println("%s, %d;", this.pool.ConstantStrValue(index), dimensions);
                    }
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return count + 1;
            }
            case opc_sipush: {
                int count = 2;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(operand, 18)).println(this.getShort(pc + 1) + ";");
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 3;
            }
            case opc_bipush: {
                int count = 1;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(operand, 18)).println(this.getByte(pc + 1) + ";");
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 2;
            }
            case opc_jsr: 
            case opc_goto: 
            case opc_ifeq: 
            case opc_ifge: 
            case opc_ifgt: 
            case opc_ifle: 
            case opc_iflt: 
            case opc_ifne: 
            case opc_if_icmpeq: 
            case opc_if_icmpne: 
            case opc_if_icmpge: 
            case opc_if_icmpgt: 
            case opc_if_icmple: 
            case opc_if_icmplt: 
            case opc_if_acmpeq: 
            case opc_if_acmpne: 
            case opc_ifnull: 
            case opc_ifnonnull: {
                int count = 2;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(operand, 18)).println(((MethodData)this.data).getLabelPrefix() + (pc + this.getShort(pc + 1)) + ";");
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 3;
            }
            case opc_jsr_w: 
            case opc_goto_w: {
                int count = 4;
                List<Byte> validBytes = this.checkCodeBounds(pc, count);
                if (validBytes.size() == count) {
                    this.print(this.PadRight(operand, 18)).println(((MethodData)this.data).getLabelPrefix() + (pc + this.getInt(pc + 1)) + ";");
                } else {
                    this.printBytes(opcode.byteValue(), validBytes, shift);
                }
                return 5;
            }
        }
        this.println(operand + ";");
        return 1;
    }

    private void printBytes(byte opcode, List<Byte> bytes, int shift) {
        this.print(this.PadRight(OpcodeTables.Opcode.opc_bytecode.parseKey(), 18)).println(HexUtils.toHex(opcode) + ";");
        for (byte b : bytes) {
            this.printPadLeft(" ", shift).print(this.PadRight(OpcodeTables.Opcode.opc_bytecode.parseKey(), 18)).println(HexUtils.toHex(b) + ";");
        }
    }

    private List<Byte> checkCodeBounds(int ind, int count) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        int codeLength = this.code.length;
        for (int i = 1; i <= count; ++i) {
            if (ind + i >= codeLength) {
                return list;
            }
            list.add(this.code[i]);
        }
        return list;
    }

    private Pair<Integer, Integer>[] getLookupswitchPairs(int pad, int count) {
        try {
            Pair[] pairs = new Pair[count];
            for (int i = 1; i <= count; ++i) {
                pairs[i - 1] = new Pair<Integer, Integer>(this.getInt(pad + i * 8), this.getInt(pad + 4 + i * 8));
            }
            return pairs;
        }
        catch (NegativeArraySizeException e) {
            throw new IndexOutOfBoundsException(this.environment.getInfo("err.out.of.range", count));
        }
    }

    @Override
    public void print() throws IOException {
        if (this.lineNumberTable != null) {
            this.loadLineNumTable();
        }
        if (this.stackMapTable != null && !this.tableFormat) {
            this.loadStackMap();
        }
        if (!((MethodData)this.data).printProgramCounter) {
            this.loadLabelTable();
        }
        this.loadTrapTable();
        if (this.localVariableTable != null) {
            this.loadLocalVariableTable();
        }
        if (this.localVariableTypeTable != null) {
            this.loadLocalVariableTypeTable();
        }
        this.incIndent().printIndentLn("%s %d  %s %d", JasmTokens.Token.STACK.parseKey(), this.max_stack, JasmTokens.Token.LOCAL.parseKey(), this.max_locals).decIndent();
        ((MethodData)this.data).printMethodParameters();
        this.printIndentLn("{");
        InstructionAttr insAttr = this.instructionAttrs.get(0);
        this.setCommentOffset(this.getCommentOffset() - this.instructionOffset - this.getIndentSize());
        int pc = 0;
        while (pc < this.code.length) {
            if (insAttr != null) {
                this.incIndent();
                insAttr.setCommentOffset(this.getCommentOffset());
                insAttr.printBegins(this.attributeOffset);
                this.decIndent();
            }
            if (((MethodData)this.data).printProgramCounter) {
                this.incIndent();
                this.printIndent(this.PadRight(String.format("%2d:", pc), this.instructionOffset));
            } else {
                this.printIndent(this.PadRight((String)(insAttr != null && insAttr.referred ? ((MethodData)this.data).getLabelPrefix() + pc + ":" : " "), this.instructionOffset));
                this.incIndent();
            }
            if (insAttr != null && insAttr.printStackMap_Table(this.attributeOffset)) {
                this.print(this.enlargedIndent(this.attributeOffset));
            }
            if ((insAttr = this.instructionAttrs.get(pc += this.printInstrLn(pc, this.attributeOffset + this.getIndentSize()))) != null) {
                insAttr.printEnds(this.attributeOffset);
                this.decIndent();
            }
            this.decIndent();
        }
        if (insAttr != null && insAttr.stackMapEntry != null && insAttr.referred) {
            if (((MethodData)this.data).printProgramCounter) {
                this.incIndent();
                this.printIndent(this.PadRight("%2d:".formatted(this.code.length), 0));
                this.decIndent();
            } else {
                this.printIndent(this.PadRight("%s%d:".formatted(((MethodData)this.data).getLabelPrefix(), this.code.length), this.code.length), 0);
            }
        }
        this.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
        this.printAttributes(this.lineNumberTable, this.localVariableTable, this.localVariableTypeTable, this.stackMapTable);
        this.printIndentLn("}");
    }

    @Override
    public MemberData<MethodData> setSignature(SignatureData signatureData) {
        throw new RuntimeException("The Code Attribute does not have a signature attribute");
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    protected <T extends AnnotationData> void printAnnotations(List<T> ... annotationLists) throws IOException {
        boolean firstTime = true;
        for (List<T> list : annotationLists) {
            if (list == null) continue;
            this.println(firstTime);
            for (AnnotationData annotation : list) {
                firstTime = false;
                annotation.print();
                this.println();
            }
        }
    }
}

