/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.AttributeData;
import org.openjdk.asmtools.jdis.ClassData;

public class EnclosingMethodData
extends AttributeData<EnclosingMethodData> {
    public EnclosingMethodData(ClassData classData) {
        super(classData, TableFormatModel.Token.ENCLOSING_METHOD);
    }

    @Override
    public String calculateName() {
        if (this.name == null) {
            this.name = this.printCPIndex ? this.pool.getClassName(this.cpx, index -> this.logger.getResourceString("info.invalid_cp_entry", new Object[0])) : "\"".concat(this.pool.getClassName(this.cpx, index -> "%s #%d".formatted(this.logger.getResourceString("info.invalid_cp_entry", new Object[0]), index))).concat("\"");
            if (this.methodCpx != 0) {
                this.name = this.name + ":" + this.pool.getMethodName(this.methodCpx);
            }
        }
        return this.name;
    }

    public EnclosingMethodData getName() {
        this.name = this.pool.getString(this.cpx, index -> "#%d".formatted(index));
        return this;
    }
}

