/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.ELocation;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Measurable;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.SignatureData;

public class FieldData
extends MemberData<ClassData>
implements Measurable {
    protected int name_cpx;
    protected int type_cpx;
    protected int value_cpx = -1;

    public FieldData(ClassData classData) {
        super(classData);
        this.memberType = "FieldData";
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        boolean handled = true;
        switch (attributeTag) {
            case ATT_Signature: {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", EAttribute.ATT_Signature.printValue(), ELocation.field_info.toString());
                }
                this.signature = new SignatureData((ClassData)this.data).read(in, attributeLength);
                break;
            }
            case ATT_ConstantValue: {
                if (attributeLength != 2) {
                    if (this.bestEffort) {
                        this.environment.error("err.invalid.attribute.length", EAttribute.ATT_ConstantValue.printValue(), attributeLength);
                    } else {
                        throw new FormatError(this.environment.getLogger(), "err.invalid.attribute.length", new Object[]{EAttribute.ATT_ConstantValue.printValue(), attributeLength});
                    }
                }
                if (this.getListOf(EAttribute.ATT_ConstantValue).size() > 1) {
                    this.environment.warning("warn.one.attribute.required", EAttribute.ATT_ConstantValue.printValue(), ELocation.field_info.toString());
                }
                this.value_cpx = in.readUnsignedShort();
                if (!this.pool.inRange(this.value_cpx)) {
                    this.environment.warning("warn.attribute.constantvalue.incorrect", this.value_cpx);
                    break;
                }
                if (this.pool.CheckEntryType(this.value_cpx, ConstantPool.TAG.CONSTANT_INTEGER, ConstantPool.TAG.CONSTANT_FLOAT, ConstantPool.TAG.CONSTANT_DOUBLE, ConstantPool.TAG.CONSTANT_LONG, ConstantPool.TAG.CONSTANT_STRING)) break;
                ConstantPool.TAG tag = this.pool.getTag(this.value_cpx);
                String tagName = tag == null ? "unknown" : tag.printValue();
                this.environment.warning("warn.attribute.type.incorrect", tagName);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    @Override
    protected boolean handleUnrecognizedAttributes(DataInputStream in, int attributeNameCpx, int attributeLength) throws IOException {
        if (!((ClassData)this.data).pool.inRange(attributeNameCpx)) {
            this.environment.warning("warn.attribute.name.corrupted", attributeNameCpx);
        } else {
            this.environment.warning("warn.attribute.name.incorrect", attributeNameCpx);
        }
        return false;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.type_cpx = in.readUnsignedShort();
        this.readAttributes(in);
        this.environment.traceln(() -> "FieldData: name[%d]=%s type[%d]=%s%s".formatted(this.name_cpx, ((ClassData)this.data).pool.getString(this.name_cpx, index -> "#%d?".formatted(index)), this.type_cpx, ((ClassData)this.data).pool.getString(this.type_cpx, index -> "#%d?".formatted(index)), this.signature != null ? this.signature : ""));
    }

    @Override
    protected void jasmPrint(int index, int size) throws IOException {
        boolean printSignature = this.signature != null && this.signature.isPrintable() && this.tableFormat;
        super.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
        super.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
        if (this.getListOf(EAttribute.ATT_Unrecognized).size() > 0) {
            List<AttrData> list = this.getListOf(EAttribute.ATT_Unrecognized);
            for (AttrData attr : list) {
                this.printIndentLn("// Ignored unrecognized attribute: { u2 #%d; u4 %d; u1[ %s ]; }".formatted(attr.getNameCpx(), attr.getLength(), attr.dataAsString()));
            }
        }
        if (!this.printCPIndex && this.value_cpx != -1 && !this.pool.CheckEntryType(this.value_cpx, ConstantPool.TAG.CONSTANT_INTEGER, ConstantPool.TAG.CONSTANT_FLOAT, ConstantPool.TAG.CONSTANT_DOUBLE, ConstantPool.TAG.CONSTANT_LONG, ConstantPool.TAG.CONSTANT_STRING)) {
            ConstantPool.TAG tag = this.pool.getTag(this.value_cpx);
            String tagName = tag == null ? "unknown" : tag.printValue();
            this.printIndentLn("// ".concat(this.environment.getInfo("warn.attribute.constantvalue.unrecognized", this.value_cpx, tagName)));
        }
        StringBuilder prefix = new StringBuilder(this.getIndentString()).append(EModifier.asKeywords(this.access, ClassFileContext.FIELD));
        prefix.append(this.getPseudoFlagsAsString());
        prefix.append(JasmTokens.Token.FIELDREF.parseKey()).append(' ');
        int keywordPadding = Math.max(prefix.length() - this.getIndentSize() * 2, TableFormatModel.Token.SIGNATURE.parseKey().length() + this.getIndentSize());
        this.printVar(prefix, this.value_cpx != -1 ? this.getConstantValue(" = ") : null, printSignature ? ":" : ";", this.name_cpx, this.type_cpx, this.value_cpx);
        if (printSignature) {
            this.signature.setKeywordPadding(keywordPadding).incIndent().setCommentOffset(this.getCommentOffset() - this.getIndentStep() * 2);
            this.signature.print();
        }
    }

    private String getConstantValue(String prefix) {
        if (!this.printCPIndex && this.value_cpx != -1 && !this.pool.CheckEntryType(this.value_cpx, ConstantPool.TAG.CONSTANT_INTEGER, ConstantPool.TAG.CONSTANT_FLOAT, ConstantPool.TAG.CONSTANT_DOUBLE, ConstantPool.TAG.CONSTANT_LONG, ConstantPool.TAG.CONSTANT_STRING)) {
            return "";
        }
        return prefix.concat(((ClassData)this.data).pool.ConstantStrValue(this.value_cpx));
    }

    @Override
    protected void tablePrint(int index, int size) throws IOException {
        this.jasmPrint(index, size);
    }

    private String getFieldDefinitionString() {
        if (this.printCPIndex && !this.skipComments) {
            StringBuilder sb = new StringBuilder(EModifier.asKeywords(this.access, ClassFileContext.FIELD));
            sb.append(this.getPseudoFlagsAsString());
            sb.append(JasmTokens.Token.FIELDREF.parseKey()).append(' ');
            sb.append('#').append(this.name_cpx).append(":#").append(this.type_cpx);
            if (this.signature != null && !this.signature.isPrintable()) {
                sb.append(":#").append(this.signature.getCPIndex());
            }
            if (this.value_cpx != -1) {
                sb.append(" = #").append(this.value_cpx);
            }
            sb.append(';');
            return sb.toString();
        }
        return "";
    }

    @Override
    public int getCommentOffset() {
        return Math.max(super.getCommentOffset(), this.maxSize + this.getIndentSize());
    }

    @Override
    public int getPrintSize() {
        String line = this.getFieldDefinitionString();
        return line.length();
    }

    @Override
    public void setMaxPrintSize(int size) {
        this.maxSize = size;
    }

    @Override
    public int getMaxPrintSize() {
        return this.maxSize;
    }
}

