/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.Printable;

public abstract class Indenter
implements Printable {
    public static final int UNDEFINED = -1;
    public static final int INDENT_STEP = 2;
    public static final int INDENT_OFFSET = 2;
    public static final String INDENT_CHAR = " ";
    public static final String INDENT_STRING = " ".repeat(2);
    public static final String ARGUMENT_DELIMITER = "^";
    public static final String LINE_SPLITTER = "\u2f80";
    public static final String NO_BSM_ARGUMENTS = "{}";
    public static final String NO_BSM_ARGUMENTS_REGEX = "\\{\\}";
    public static final String REPLACEMENT_NO_BSM_ARGUMENTS = "<!>";
    public static final int PROGRAM_COUNTER_PLACEHOLDER_LENGTH = 7;
    public static final int INSTR_PREFIX_LENGTH = 7;
    public static final int STACKMAP_TYPE_PLACEHOLDER_LENGTH = 18;
    public static final int OPERAND_PLACEHOLDER_LENGTH = 17;
    public static int TABLE_PADDING = 25;
    public static final int COMMENT_PADDING = Options.contains(Options.PrintOption.TABLE) ? 16 : 20;
    public static final int INITIAL_COMMENT_OFFSET = 0;
    public static final int CIRCULAR_COMMENT_OFFSET = 25;
    protected final boolean tableFormat = Options.contains(Options.PrintOption.TABLE);
    protected final boolean sysInfo = Options.contains(Options.PrintOption.SYSINFO);
    protected final boolean detailedOutput = Options.contains(Options.PrintOption.DETAILED_Output);
    protected final boolean extraDetailedOutput = Options.contains(Options.PrintOption.EXTRA_DETAILED_Output);
    protected final boolean bestEffort = Options.contains(Options.PrintOption.BEST_EFFORT);
    protected final boolean dropSourceFile = Options.contains(Options.PrintOption.DROP_Source);
    protected final boolean dropClasses = Options.contains(Options.PrintOption.DROP_Classes);
    protected final boolean dropSignatures = Options.contains(Options.PrintOption.DROP_Signatures);
    protected final boolean dropCharacterRange = Options.contains(Options.PrintOption.DROP_CharacterRange);
    protected final boolean printLocalVariables = Options.contains(Options.PrintOption.LOCAL_VARIABLE_All, Options.PrintOption.LOCAL_VARIABLE_Vars);
    protected final boolean printLocalVariableTypes = Options.contains(Options.PrintOption.LOCAL_VARIABLE_All, Options.PrintOption.LOCAL_VARIABLE_Types);
    protected final boolean printLineNumber = Options.contains(Options.PrintOption.LINE_NUMBER_TABLE_Numbers, Options.PrintOption.LINE_NUMBER_TABLE_Lines, Options.PrintOption.LINE_NUMBER_TABLE_Table, Options.PrintOption.TABLE);
    protected final boolean printCPIndex = Options.contains(Options.PrintOption.CP_INDEX);
    protected final boolean skipComments = Options.contains(Options.PrintOption.NO_COMMENTS);
    protected final boolean printProgramCounter = Options.contains(Options.PrintOption.PRINT_BCI);
    protected final boolean printLabelAsIdentifiers = Options.contains(Options.PrintOption.LABELS) && !this.printProgramCounter;
    protected final boolean printConstantPool = Options.contains(Options.PrintOption.CONSTANT_POOL);
    protected final boolean printSourceLines = Options.contains(Options.PrintOption.LINE_NUMBER_TABLE_Lines);
    protected final boolean printLineTable = Options.contains(Options.PrintOption.LINE_NUMBER_TABLE_Table);
    protected final boolean printLineTableLines = Options.contains(Options.PrintOption.LINE_NUMBER_TABLE_Lines);
    protected final boolean printLineTableNumbers = Options.contains(Options.PrintOption.LINE_NUMBER_TABLE_Numbers);
    protected final boolean printHEX = Options.contains(Options.PrintOption.HEX);
    protected boolean printable = true;
    protected boolean hasSize = false;
    protected TableFormatModel.Token tableToken = TableFormatModel.Token.NOT_SUPPORTED;
    protected int maxSize = 0;
    protected boolean maxSizeCalculated = false;
    protected ToolOutput toolOutput;
    private final String LabelPrefix = this.printLabelAsIdentifiers ? "L" : "";
    protected int commentOffset = 0;
    private int length = 0;
    private int offset = 2;
    private int step = 2;
    private String fillString = " ";
    protected static final Map<Integer, List<Integer>> InvokeDynamicBreakPositions = Map.of(0, List.of(Integer.valueOf(2), Integer.valueOf(3)), 1, List.of(Integer.valueOf(3)), 2, List.of(Integer.valueOf(3)));
    protected static final Map<Integer, List<Integer>> LdwBreakPositions = Map.of(0, List.of(Integer.valueOf(3)), 1, List.of(Integer.valueOf(3)), 2, List.of(Integer.valueOf(3)));
    protected static final Map<Integer, List<Integer>> BootstrapMethodBreakPositions = Map.of(0, List.of(Integer.valueOf(2), Integer.valueOf(3)));
    protected static final Map<Integer, List<Integer>> BootstrapArgumentsBreakPositions = Map.of(0, List.of(Integer.valueOf(3)));

    @Override
    public void print() throws IOException {
        if (this.isTableOutput()) {
            this.tablePrint();
        } else {
            this.jasmPrint();
        }
    }

    public boolean isTableOutput() {
        return this.tableFormatSupported() && this.tableFormat;
    }

    @Override
    public boolean tableFormatSupported() {
        return this.tableToken.isExtendedPrintingSupported();
    }

    protected String getTitle() {
        throw new NotImplementedException(this.getClass().getName());
    }

    protected void tablePrint() throws IOException {
        throw new NotImplementedException(this.getClass().getName());
    }

    protected void jasmPrint() throws IOException {
        throw new NotImplementedException(this.getClass().getName());
    }

    protected void tablePrint(int index, int size) throws IOException {
        throw new NotImplementedException(this.getClass().getName());
    }

    protected void jasmPrint(int index, int size) throws IOException {
        throw new NotImplementedException(this.getClass().getName());
    }

    public void print(int index, int size) throws IOException {
        if (this.isTableOutput()) {
            this.tablePrint(index, size);
        } else {
            this.jasmPrint(index, size);
        }
    }

    public Indenter(ToolOutput toolOutput) {
        this();
        this.toolOutput = toolOutput;
    }

    protected Indenter() {
    }

    protected String getLabelPrefix() {
        return this.LabelPrefix;
    }

    public Indenter printIndentLn(String s) {
        this.toolOutput.printlns(this.Indent(s));
        return this;
    }

    public Indenter printIndentLn() {
        this.toolOutput.printlns("");
        return this;
    }

    public int getIndentStep() {
        return this.step;
    }

    public Indenter printIndentLn(String format, Object ... args) {
        this.toolOutput.printlns(this.Indent(new Formatter().format(format, args).toString()));
        return this;
    }

    public Indenter printIndent(String format, Object ... args) {
        this.toolOutput.prints(this.Indent(new Formatter().format(format, args).toString()));
        return this;
    }

    public Indenter printIndent(String s) {
        String str = this.Indent(s);
        this.toolOutput.prints(str);
        return this;
    }

    public Indenter printIndent() {
        this.toolOutput.prints(this.getIndentString());
        return this;
    }

    public Indenter printPadRight(String s, int totalWidth) {
        this.toolOutput.prints(this.PadRight(s, totalWidth));
        return this;
    }

    public Indenter printPadLeft(String s, int totalWidth) {
        this.toolOutput.prints(this.PadLeft(s, totalWidth));
        return this;
    }

    public Indenter printIndentPadRight(String str, int totalWidth) {
        this.toolOutput.prints(this.IndentPadRight(str, totalWidth));
        return this;
    }

    public Indenter printIndentPadLeft(String str, int totalWidth) {
        this.toolOutput.prints(this.IndentPadLeft(str, totalWidth));
        return this;
    }

    public Indenter print(String s) {
        this.toolOutput.prints(s);
        return this;
    }

    public Indenter print(String format, Object ... args) {
        this.toolOutput.prints(new Formatter().format(format, args).toString());
        return this;
    }

    public Indenter println(String s) {
        this.toolOutput.printlns(s);
        return this;
    }

    public Indenter println() {
        this.toolOutput.printlns("");
        return this;
    }

    public Indenter println(boolean isPrint) {
        if (isPrint) {
            this.toolOutput.printlns("");
        }
        return this;
    }

    public Indenter println(String format, Object ... args) {
        this.toolOutput.printlns(new Formatter().format(format, args).toString());
        return this;
    }

    public Indenter incIndent() {
        return this.incIndent(1);
    }

    public Indenter decIndent() {
        return this.decIndent(1);
    }

    public Indenter incIndent(int count) {
        this.length += this.step * count;
        return this;
    }

    public Indenter decIndent(int count) {
        this.length -= this.step * count;
        if (this.length < 0) {
            this.length = 0;
        }
        return this;
    }

    public Indenter setTheSame(Indenter that) {
        this.length = that.length;
        this.offset = that.offset;
        this.step = that.step;
        this.commentOffset = that.commentOffset;
        this.fillString = that.fillString;
        return this;
    }

    public Indenter initIndent(int initialOffset) {
        this.length = 0;
        this.step = 2;
        this.offset = initialOffset;
        this.fillString = INDENT_CHAR;
        return this;
    }

    public int getIndentSize() {
        return this.offset + this.length;
    }

    public String nCopies(int n) {
        return String.join((CharSequence)"", Collections.nCopies(n < 0 ? 0 : n, this.fillString));
    }

    public String getIndentString() {
        return this.nCopies(this.getIndentSize());
    }

    public String IndentPadLeft(String str, int totalWidth) {
        return this.getIndentString() + this.PadLeft(str, totalWidth);
    }

    public String IndentPadRight(String str, int totalWidth) {
        return this.getIndentString() + this.PadRight(str, totalWidth);
    }

    public String PadLeft(String str, int totalWidth) {
        int count;
        if (totalWidth > 0 && (count = totalWidth - ((String)str).length()) > 0) {
            str = this.nCopies(count) + (String)str;
        }
        return str;
    }

    public String PadRight(String str, int totalWidth) {
        int count;
        if (totalWidth > 0 && (count = totalWidth - ((String)str).length()) > 0) {
            str = (String)str + this.nCopies(count);
        }
        return str;
    }

    public String padRight(String value, int width, char pad) {
        if (value.length() >= width) {
            return value;
        }
        char[] buf = new char[width];
        Arrays.fill(buf, value.length(), width, pad);
        value.getChars(0, value.length(), buf, 0);
        return new String(buf);
    }

    public String padLeft(String value, int width, char pad) {
        if (value.length() >= width) {
            return value;
        }
        char[] buf = new char[width];
        int padLen = width - value.length();
        Arrays.fill(buf, 0, padLen, pad);
        value.getChars(0, value.length(), buf, padLen);
        return new String(buf);
    }

    public String Indent(String str) {
        return this.getIndentString() + str;
    }

    public String enlargedIndent(String str, int shift) {
        this.offset += shift;
        str = this.Indent(str);
        this.offset -= shift;
        return str;
    }

    public String enlargedIndent(int shift) {
        return this.enlargedIndent("", shift);
    }

    public int getCommentOffset() {
        return this.commentOffset;
    }

    public Indenter setCommentOffset(int commentOffset) {
        this.commentOffset = commentOffset;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public Indenter setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    protected int getPrintAttributeKeyPadding() {
        int instructionOffset = this.printProgramCounter ? 7 : 7;
        int attributeOffset = this.printProgramCounter ? instructionOffset : instructionOffset - this.getIndentStep();
        return instructionOffset + attributeOffset + 17 - this.getIndentSize() * 2;
    }

    protected int getPrintAttributeCommentPadding() {
        return this.getCommentOffset() - this.getPrintAttributeKeyPadding();
    }

    public Indenter setHasSize(boolean hasSize) {
        this.hasSize = hasSize;
        return this;
    }

    protected String formatOperandLine(String str, int offset, String prefix, Map<Integer, List<Integer>> breakPositions) {
        boolean noArgs = str.contains(NO_BSM_ARGUMENTS);
        if (noArgs) {
            str = str.replaceAll(NO_BSM_ARGUMENTS_REGEX, REPLACEMENT_NO_BSM_ARGUMENTS);
        }
        StringTokenizer st = new StringTokenizer(str, ":\"{}\\^\u2f80", true);
        StringBuilder sb = new StringBuilder(80);
        boolean processTokens = true;
        String prevToken = "";
        int nItems = 0;
        int nLevel = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            List breaks = breakPositions.getOrDefault(nLevel, Collections.emptyList());
            switch (token) {
                case ":": {
                    sb.append(token);
                    if (!processTokens || !breaks.contains(++nItems)) break;
                    sb.append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * nLevel));
                    break;
                }
                case "}": {
                    if (processTokens) {
                        nLevel = nLevel == 0 ? nLevel : nLevel - 1;
                        nItems = 0;
                        sb.append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * nLevel)).append(token);
                        break;
                    }
                    sb.append(token);
                    break;
                }
                case "{": {
                    if (processTokens) {
                        nItems = 0;
                        sb.append(" {").append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * ++nLevel));
                        break;
                    }
                    sb.append(token);
                    break;
                }
                case "\"": {
                    if (!prevToken.equals("\\")) {
                        processTokens = !processTokens;
                    }
                    sb.append(token);
                    break;
                }
                case "^": {
                    if (processTokens) {
                        sb.append(',').append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * nLevel));
                        nItems = 0;
                        break;
                    }
                    sb.append(ARGUMENT_DELIMITER);
                    break;
                }
                case "\u2f80": {
                    if (processTokens) {
                        sb.append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * nLevel));
                        break;
                    }
                    sb.append(ARGUMENT_DELIMITER);
                    break;
                }
                default: {
                    sb.append(token);
                }
            }
            prevToken = token;
        }
        str = sb.toString();
        if (noArgs) {
            str = str.replaceAll(REPLACEMENT_NO_BSM_ARGUMENTS, NO_BSM_ARGUMENTS);
        }
        return str;
    }

    public static class NotImplementedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotImplementedException(String where) {
            super("".formatted(where));
        }
    }
}

