/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Container;
import org.openjdk.asmtools.jdis.Element;
import org.openjdk.asmtools.jdis.Measurable;

public class InnerClassData
extends Element<ClassData>
implements Measurable {
    int inner_class_info_index;
    int outer_class_info_index;
    int inner_name_index;
    int access;
    private int calculatedCommentOffset = 0;
    private String jasmPrefix = this.Indent(this.PadRight(JasmTokens.Token.INNERCLASS.parseKey(), TABLE_PADDING));

    public InnerClassData(ClassData classData, Container<InnerClassData, ClassData> container) {
        super(classData, container);
        this.tableToken = TableFormatModel.Token.INNER_CLASSES;
    }

    @Override
    public int getCommentOffset() {
        if (this.calculatedCommentOffset == 0) {
            if (this.isTableOutput()) {
                this.calculatedCommentOffset = this.container.getCommentOffset() - this.getIndentStep();
                this.calculatedCommentOffset = Math.max(this.calculatedCommentOffset, this.getMaxPrintSize());
            } else {
                this.calculatedCommentOffset = this.container.getCommentOffset() - this.getIndentStep();
                this.calculatedCommentOffset = Math.max(this.calculatedCommentOffset, this.getMaxPrintSize() + this.jasmPrefix.length());
            }
        }
        return this.calculatedCommentOffset;
    }

    public void read(DataInputStream in) throws IOException {
        this.inner_class_info_index = in.readUnsignedShort();
        this.outer_class_info_index = in.readUnsignedShort();
        this.inner_name_index = in.readUnsignedShort();
        this.access = in.readUnsignedShort();
    }

    @Override
    public void jasmPrint(int index, int size) throws IOException {
        String line = this.jasmPrefix.concat(EModifier.asKeywords(this.access, ClassFileContext.INNER_CLASS));
        if (this.printCPIndex) {
            line = this.getClassDefinitionString(line);
            if (this.skipComments) {
                this.print(line);
            } else {
                this.print(this.PadRight(line, this.getCommentOffset())).print(" // ");
            }
        } else {
            this.print(line);
        }
        if (!this.printCPIndex || this.printCPIndex && !this.skipComments) {
            if (this.inner_name_index != 0) {
                this.print(((ClassData)this.owner).pool.getName(this.inner_name_index) + " = ");
            }
            if (this.inner_class_info_index != 0) {
                this.print(((ClassData)this.owner).pool.ConstantStrValue(this.inner_class_info_index));
            }
            if (this.outer_class_info_index != 0) {
                this.print(String.format(" of %s", ((ClassData)this.owner).pool.ConstantStrValue(this.outer_class_info_index)));
            }
            this.println(((ClassData)this.owner).printCPIndex && !this.skipComments ? "" : ";");
        } else {
            this.println();
        }
    }

    @Override
    public void tablePrint(int index, int size) throws IOException {
        if (index == 0) {
            this.printIndentLn("%s {".formatted(JasmTokens.Token.INNERCLASS.alias()));
        }
        this.incIndent();
        String prefix = EModifier.asKeywords(this.access, ClassFileContext.INNER_CLASS);
        if (this.printCPIndex) {
            prefix = this.getClassDefinitionString(prefix);
            if (this.skipComments) {
                this.printIndent(prefix);
            } else {
                this.printIndentPadRight(prefix, this.getCommentOffset()).print(" // ");
            }
        } else {
            this.printIndent(prefix);
        }
        if (!this.printCPIndex || this.printCPIndex && !this.skipComments) {
            if (this.inner_name_index != 0) {
                this.print("%s = ".formatted(((ClassData)this.owner).pool.getName(this.inner_name_index)));
            }
            if (this.inner_class_info_index != 0) {
                this.print(((ClassData)this.owner).pool.ConstantStrValue(this.inner_class_info_index));
            }
            if (this.outer_class_info_index != 0) {
                this.print(String.format(" of %s", ((ClassData)this.owner).pool.ConstantStrValue(this.outer_class_info_index)));
            }
            this.println(((ClassData)this.owner).printCPIndex && !this.skipComments ? "" : ";");
        } else {
            this.println();
        }
        this.decIndent();
        if (index == size - 1) {
            this.printIndentLn("}");
        }
    }

    private String getClassDefinitionString(String line) {
        if (this.inner_name_index != 0) {
            line = line.concat("#%d = ".formatted(this.inner_name_index));
        }
        if (this.inner_class_info_index != 0) {
            line = line.concat("#%d".formatted(this.inner_class_info_index));
        }
        if (this.outer_class_info_index != 0) {
            line = line.concat(" of #%d".formatted(this.outer_class_info_index));
        }
        return line.concat(";");
    }

    @Override
    public int getPrintSize() {
        String line = this.getClassDefinitionString(EModifier.asKeywords(this.access, ClassFileContext.INNER_CLASS));
        return line.length() + 1;
    }

    @Override
    public void setMaxPrintSize(int size) {
        this.maxSize = size;
    }

    @Override
    public int getMaxPrintSize() {
        return this.maxSize;
    }
}

