/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.LocalVariableData;
import org.openjdk.asmtools.jdis.LocalVariableTypeData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.StackMapData;
import org.openjdk.asmtools.jdis.TrapData;

class InstructionAttr
extends MemberData<MethodData> {
    short lineNum = 0;
    boolean referred = false;
    ArrayList<LocalVariableData> vars;
    ArrayList<LocalVariableTypeData> types;
    ArrayList<LocalVariableData> endVars;
    ArrayList<LocalVariableTypeData> endTypes;
    ArrayList<TrapData> handlers;
    ArrayList<TrapData> traps;
    ArrayList<TrapData> endTraps;
    List<StackMapData> stackMapWrappers;
    StackMapData stackMapEntry;
    ClassData classData;
    private int attributeOffset;

    public InstructionAttr(MethodData methodData) {
        super(methodData);
        this.classData = (ClassData)methodData.data;
    }

    void addTrap(TrapData trap) {
        if (this.traps == null) {
            this.traps = new ArrayList(4);
        }
        this.traps.add(trap);
    }

    void addEndTrap(TrapData endTrap) {
        if (this.endTraps == null) {
            this.endTraps = new ArrayList(4);
        }
        this.endTraps.add(endTrap);
    }

    void add_handler(TrapData endHandler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList(4);
        }
        this.handlers.add(endHandler);
    }

    public void printBegins(int shift) {
        this.attributeOffset = shift;
        this.printInlinedLineNumber();
        this.printBeginOfExceptionHandlers(shift);
        this.printBeginOfTrapScores(shift);
        this.printBeginOfLocVars(shift);
    }

    public void printEnds(int shift) {
        if (this.endTypes != null && !this.tableFormat) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_endtype.parseKey(), 18), shift));
            this.println(this.endTypes.stream().map(ev -> Short.toString(ev.slot)).collect(Collectors.joining(",")) + ";");
        }
        if (this.endVars != null && !this.tableFormat) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_endvar.parseKey(), 18), shift));
            this.println(this.endVars.stream().map(ev -> Short.toString(ev.slot)).collect(Collectors.joining(",")) + ";");
        }
        if (this.endTraps != null) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_endtry.parseKey(), 18), shift));
            this.println(this.endTraps.stream().map(TrapData::id).collect(Collectors.joining(",")) + ";");
        }
    }

    public boolean printStackMap_Table(int shift) {
        if (this.tableFormat || this.stackMapEntry == null && this.stackMapWrappers == null) {
            return false;
        }
        if (this.stackMapEntry != null) {
            return this.stackMapEntry.belongsToStackMapTable() ? this.printStackMapTable(shift) : this.printStackMap(shift);
        }
        return this.stackMapWrappers.get(0).belongsToStackMapTable() ? this.printStackMapTable(shift) : this.printStackMap(shift);
    }

    private boolean printStackMapTable(int shift) {
        int mapShift = this.getCommentOffset() - 18;
        boolean wrapped = this.stackMapWrappers != null;
        String opCodeName = OpcodeTables.Opcode.opc_stack_frame_type.parseKey();
        Object prefix = "";
        Object listPrefix = INDENT_STRING;
        if (wrapped) {
            for (int i = 0; i < this.stackMapWrappers.size(); ++i) {
                StackMapData smd = this.stackMapWrappers.get(i);
                if (i > 0) {
                    opCodeName = OpcodeTables.Opcode.opc_frame_type.parseKey();
                    prefix = INDENT_STRING;
                    listPrefix = (String)prefix + INDENT_STRING;
                }
                this.printPadRight((String)prefix + opCodeName, 18);
                if (this.printCPIndex && !this.skipComments) {
                    this.print(this.PadRight(smd.stackEntryType.tagName() + ";", mapShift)).println(" // %s %s".formatted(JasmTokens.Token.FRAMETYPE.parseKey(), smd.stackEntryTypeValue));
                } else {
                    this.println(smd.stackEntryType.tagName() + ";");
                }
                int[] unsetFields = smd.unsetFields;
                this.printFields(unsetFields, shift);
                if (unsetFields == null || unsetFields.length == 0) {
                    this.println(this.enlargedIndent((String)listPrefix + OpcodeTables.Opcode.opc_unset_fields.parseKey() + ";", shift));
                }
                this.print(this.enlargedIndent(this.attributeOffset));
            }
        }
        opCodeName = OpcodeTables.Opcode.opc_stack_frame_type.parseKey();
        if (this.stackMapEntry != null) {
            int[] stackMap;
            if (wrapped) {
                opCodeName = OpcodeTables.Opcode.opc_frame_type.parseKey();
                prefix = (String)prefix + INDENT_STRING;
            }
            listPrefix = (String)prefix + INDENT_STRING;
            this.printPadRight((String)prefix + opCodeName, 18);
            if (this.printCPIndex && !this.skipComments) {
                this.print(this.PadRight(this.stackMapEntry.stackEntryType.tagName() + ";", mapShift)).println(" // %s %s".formatted(JasmTokens.Token.FRAMETYPE.parseKey(), this.stackMapEntry.stackEntryTypeValue));
            } else {
                this.println(this.stackMapEntry.stackEntryType.tagName() + ";");
            }
            int[] lockMap = this.stackMapEntry.lockMap;
            if (lockMap == null || lockMap.length == 0) {
                if (this.stackMapEntry.stackEntryType.hasLocalMap()) {
                    this.println(this.enlargedIndent((String)listPrefix + OpcodeTables.Opcode.opc_locals_map.parseKey() + ";", shift));
                }
            } else {
                mapShift = this.printEntries(this.stackMapEntry.getMapListAsString(lockMap, ""), (String)listPrefix + OpcodeTables.Opcode.opc_locals_map.parseKey(), shift, mapShift);
            }
            if ((stackMap = this.stackMapEntry.stackMap) == null || stackMap.length == 0) {
                if (this.stackMapEntry.stackEntryType.hasStackMap()) {
                    this.println(this.enlargedIndent((String)listPrefix + OpcodeTables.Opcode.opc_stack_map.parseKey() + ";", shift));
                }
            } else {
                this.printEntries(this.stackMapEntry.getMapListAsString(stackMap, ""), (String)listPrefix + OpcodeTables.Opcode.opc_stack_map.parseKey(), shift, mapShift);
            }
        }
        return this.stackMapWrappers != null || this.stackMapEntry != null;
    }

    private boolean printStackMap(int shift) {
        int mapShift = this.getCommentOffset() - 18;
        this.printPadRight(OpcodeTables.Opcode.opc_stack_map_frame.parseKey() + ";", 18);
        if (this.printCPIndex && !this.skipComments) {
            this.print(this.PadRight(" ", mapShift)).println(" // offset " + this.stackMapEntry.frame_pc);
        } else {
            this.println();
        }
        mapShift = this.printEntries(this.stackMapEntry.getMapListAsString(this.stackMapEntry.lockMap, ""), OpcodeTables.Opcode.opc_locals_map.parseKey(), shift, mapShift);
        this.printEntries(this.stackMapEntry.getMapListAsString(this.stackMapEntry.stackMap, ""), OpcodeTables.Opcode.opc_stack_map.parseKey(), shift, mapShift);
        return true;
    }

    private void printFields(int[] unsetFields, int shift) {
        block10: {
            int mapShift = this.getCommentOffset() - 18;
            if (unsetFields == null || unsetFields.length <= 0) break block10;
            int limit = unsetFields.length - 1;
            Pair<List<String>, List<String>> line = this.stackMapEntry.getFieldListAsString(unsetFields);
            String left = ((List)line.first).stream().collect(Collectors.joining(", ")).concat(";");
            String right = ((List)line.second).stream().collect(Collectors.joining(", ")).concat(";");
            String title = this.enlargedIndent(this.PadRight(INDENT_STRING + OpcodeTables.Opcode.opc_unset_fields.parseKey(), 18), shift);
            this.print(title);
            title = this.nCopies(title.length());
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.println(left);
                } else if (limit == 0) {
                    this.print(this.PadRight(left, mapShift)).println(" // " + right);
                } else {
                    this.print(this.PadRight(((String)((List)line.first).get(0)).concat(","), mapShift)).println(" // " + ((String)((List)line.second).get(0)).concat(","));
                    for (int i = 1; i <= limit; ++i) {
                        String delim = i == limit ? ";" : ",";
                        String id = ((String)((List)line.first).get(i)).concat(delim);
                        String field = ((String)((List)line.second).get(i)).concat(delim);
                        this.print(title).print(this.PadRight(id, mapShift)).println(" // " + field);
                    }
                }
            } else if (limit == 0) {
                this.println(right);
            } else {
                this.println(((String)((List)line.second).get(0)).concat(","));
                for (int i = 1; i <= limit; ++i) {
                    String delim = i == limit ? ";" : ",";
                    String field = ((String)((List)line.second).get(i)).concat(delim);
                    this.print(title).println(field);
                }
            }
        }
    }

    private int printEntries(Pair<String, String> entriesLine, String title, int shift, int mapShift) {
        if (entriesLine != null) {
            boolean isEmpty = ((String)entriesLine.first).isEmpty() && ((String)entriesLine.second).isEmpty();
            this.print(this.enlargedIndent(this.PadRight(title + (isEmpty ? ";" : ""), 18), shift));
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.println((String)entriesLine.first);
                } else {
                    this.print(this.PadRight((String)entriesLine.first, mapShift));
                    mapShift = Math.max(mapShift, ((String)entriesLine.first).length());
                    if (!isEmpty) {
                        this.print(" // ");
                    }
                }
            }
            if (!this.printCPIndex || this.printCPIndex && !this.skipComments) {
                this.println((String)entriesLine.second);
            }
        }
        return mapShift;
    }

    void addVar(LocalVariableData var) {
        if (this.vars == null) {
            this.vars = new ArrayList(4);
        }
        this.vars.add(var);
    }

    void addType(LocalVariableTypeData type) {
        if (this.types == null) {
            this.types = new ArrayList(4);
        }
        this.types.add(type);
    }

    void addEndType(LocalVariableTypeData endType) {
        if (this.endTypes == null) {
            this.endTypes = new ArrayList(4);
        }
        this.endTypes.add(endType);
    }

    void addEndVar(LocalVariableData endVar) {
        if (this.endVars == null) {
            this.endVars = new ArrayList(4);
        }
        this.endVars.add(endVar);
    }

    private void printInlinedLineNumber() {
        boolean bothOpt;
        boolean eitherOpt = ((MethodData)this.data).printLineTableNumbers || ((MethodData)this.data).printLineTableLines;
        boolean bl = bothOpt = ((MethodData)this.data).printLineTableNumbers && ((MethodData)this.data).printLineTableLines;
        if (eitherOpt && this.lineNum != 0) {
            this.decIndent();
            if (bothOpt) {
                String srcLine = this.classData.getSrcLine(this.lineNum);
                this.printIndentLn("// " + this.lineNum + (String)(srcLine != null ? "# " + srcLine : ""));
            } else if (((MethodData)this.data).printLineTableNumbers) {
                this.printIndentLn("// %d#", this.lineNum);
            } else if (((MethodData)this.data).printLineTableLines) {
                String srcLine = this.classData.getSrcLine(this.lineNum);
                this.printIndentLn((String)(srcLine != null ? "// " + srcLine : ""));
            }
            this.incIndent();
        }
    }

    private void printBeginOfExceptionHandlers(int shift) {
        if (this.handlers != null) {
            for (TrapData line : this.handlers) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_catch.parseKey(), 18), shift));
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println("%s #%d;", line.id(), line.catch_cpx);
                        continue;
                    }
                    this.print(this.PadRight(String.format("%s #%d;", line.id(), line.catch_cpx), this.getCommentOffset() - 18));
                    this.println(" // " + (line.catch_cpx == 0 ? "any" : ((MethodData)this.data).pool.getClassName(line.catch_cpx)));
                    continue;
                }
                this.println("%s %s;", line.id(), ((MethodData)this.data).pool.getClassName(line.catch_cpx));
            }
        }
    }

    private void printBeginOfTrapScores(int shift) {
        if (this.traps != null) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_try.parseKey(), 18), shift));
            this.println(this.traps.stream().map(TrapData::id).collect(Collectors.joining(", ")) + ";");
        }
    }

    private void printBeginOfLocVars(int shift) {
        if (this.vars != null && !this.tableFormat) {
            for (LocalVariableData line : this.vars) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_var.parseKey(), 18), shift));
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println("%d #%d:#%d;", line.slot, line.name_cpx, line.sig_cpx);
                        continue;
                    }
                    this.print(this.PadRight(String.format("%d #%d:#%d;", line.slot, line.name_cpx, line.sig_cpx), this.getCommentOffset() - 18));
                    this.println(" // %s:%s", ((MethodData)this.data).pool.getName(line.name_cpx), ((MethodData)this.data).pool.getName(line.sig_cpx));
                    continue;
                }
                this.println("%d %s:%s;", line.slot, ((MethodData)this.data).pool.getName(line.name_cpx), ((MethodData)this.data).pool.getName(line.sig_cpx));
            }
        }
        if (this.types != null && !this.tableFormat) {
            for (LocalVariableTypeData type : this.types) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_type.parseKey(), 18), shift));
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println("%d #%d:#%d;", type.slot, type.name_cpx, type.sig_cpx);
                        continue;
                    }
                    this.print(this.PadRight(String.format("%d #%d:#%d;", type.slot, type.name_cpx, type.sig_cpx), this.getCommentOffset() - 18));
                    this.println(" // %s:%s", ((MethodData)this.data).pool.getName(type.name_cpx), ((MethodData)this.data).pool.getName(type.sig_cpx));
                    continue;
                }
                this.println("%d %s:%s;", type.slot, ((MethodData)this.data).pool.getName(type.name_cpx), ((MethodData)this.data).pool.getName(type.sig_cpx));
            }
        }
    }
}

