/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;

public abstract class LocalData<M extends MemberData<?>>
extends Indenter {
    protected short start_pc;
    protected short length;
    protected short name_cpx;
    protected short sig_cpx;
    protected short slot;
    protected ConstantPool pool;
    protected String header;
    protected String format;

    public LocalData(MemberData<M> owner, DataInputStream in, MethodData methodData, String fieldFacet) throws IOException {
        this.start_pc = in.readShort();
        this.length = in.readShort();
        this.name_cpx = in.readShort();
        this.sig_cpx = in.readShort();
        this.slot = in.readShort();
        this.toolOutput = methodData.toolOutput;
        this.pool = methodData.getConstantPool();
        int shift = methodData.calculateInlinedTitleShift("Start");
        this.header = MessageFormat.format("%{0}s  Length  Slot  Name    %s", shift).formatted("Start", fieldFacet);
        this.format = MessageFormat.format("%{0}d  %6d  %4d  %4s  %s", shift);
    }

    @Override
    public int getCommentOffset() {
        return super.getCommentOffset() + 7;
    }

    @Override
    protected void tablePrint(int index, int size) throws IOException {
        this.incIndent();
        if (index == 0) {
            this.printIndentLn(this.getTitle());
            this.printIndentLn(this.header);
        }
        String nameCpx = this.PadRight("#%s".formatted(this.name_cpx), 6);
        String name = this.pool.StringValue(this.name_cpx);
        String type = this.pool.StringValue(this.sig_cpx);
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.printIndentLn(this.format.formatted(this.start_pc, this.length, this.slot, nameCpx, "#%s".formatted(this.sig_cpx)));
            } else {
                String str = this.format.formatted(this.start_pc, this.length, this.slot, nameCpx, "%-4s".formatted("#" + this.sig_cpx));
                this.printIndent(this.PadRight(str, this.getCommentOffset()));
                this.println(" // %s:%s".formatted(name, type));
            }
        } else {
            this.printIndentLn(this.format.formatted(this.start_pc, this.length, this.slot, this.PadRight(name, 6), type));
        }
    }
}

