/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.inputs.FileInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.FSOutput;
import org.openjdk.asmtools.common.outputs.StdoutOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualOutputStreamOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.JdisEnvironment;
import org.openjdk.asmtools.jdis.JdisTool;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends JdisTool {
    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput ... toolInputs) {
        super(toolOutput, log);
        Collections.addAll(this.fileList, toolInputs);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput) {
        super(toolOutput, log);
        this.fileList.add(toolInput);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput, String ... argv) {
        super(toolOutput, log);
        if (toolInput != null) {
            this.fileList.add(toolInput);
        }
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, String ... argv) {
        super(toolOutput);
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput logger, String ... argv) {
        super(toolOutput, logger);
        this.parseArgs(argv);
    }

    public static void main(String ... argv) {
        Main disassembler = new Main((ToolOutput)new StdoutOutput(), argv);
        System.exit(disassembler.disasm());
    }

    public synchronized boolean disasm(String ... argv) {
        this.parseArgs(argv);
        return this.disasm() == 0;
    }

    @Override
    public synchronized int decode() {
        return this.disasm();
    }

    @Override
    public synchronized boolean decode(String ... argv) {
        return this.disasm(argv);
    }

    public synchronized int disasm() {
        int rc = 0;
        for (ToolInput toolInput : this.fileList) {
            ClassData classData = null;
            try {
                ((JdisEnvironment)this.environment).setToolInput(toolInput);
                classData = new ClassData((JdisEnvironment)this.environment);
                toolInput.setDetailedInput(classData.isDetailedOutput());
                try (DataInputStream dis = toolInput.getDataInputStream(Optional.of(this.environment));){
                    classData.read(dis, Paths.get(toolInput.getName(), new String[0]));
                }
                ((JdisEnvironment)this.environment).traceln(() -> "Options:\n%s\n".formatted(Options.getPrintOptions()));
                ((JdisEnvironment)this.environment).getToolOutput().startClass(classData.className, Optional.of(".jasm"), this.environment);
                classData.print();
                ((JdisEnvironment)this.environment).getToolOutput().finishClass(classData.className);
                ((JdisEnvironment)this.environment).getOutputs().flush();
                rc += ((DecompilerLogger)((JdisEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
                ((DecompilerLogger)((JdisEnvironment)this.environment).getLogger()).flush();
                continue;
            }
            catch (FileNotFoundException fnf) {
                ((JdisEnvironment)this.environment).printException(fnf);
                ((JdisEnvironment)this.environment).error("err.not_found", toolInput);
                rc = 1;
            }
            catch (IOException | ClassFormatError ioe) {
                classData.postPrint();
                ((JdisEnvironment)this.environment).error(ioe);
                ((JdisEnvironment)this.environment).printException(ioe);
                rc += ((DecompilerLogger)((JdisEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
            }
            catch (Error error) {
                classData.postPrint();
                ((JdisEnvironment)this.environment).error(error);
                ((JdisEnvironment)this.environment).printException(error);
                rc += ((DecompilerLogger)((JdisEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
            }
            catch (Exception ex) {
                classData.postPrint();
                ((JdisEnvironment)this.environment).error(ex);
                ((JdisEnvironment)this.environment).printException(ex);
                rc += ((DecompilerLogger)((JdisEnvironment)this.environment).getLogger()).registerTotalIssues(rc, toolInput);
            }
            ((DecompilerLogger)((JdisEnvironment)this.environment).getLogger()).flush();
            break;
        }
        return rc;
    }

    @Override
    public void usage() {
        ((JdisEnvironment)this.environment).usage(List.of("info.usage", "info.opt.d", "info.opt.w", "info.opt.g", "info.opt.gg", "info.opt.nc", "info.opt.table", "info.opt.hx", "info.opt.instr.offset", "info.opt.sysinfo", "info.opt.lnt", "info.opt.lvt", "info.opt.drop", "info.opt.b", "info.opt.version", "info.opt.t", "info.opt.v"));
    }

    @Override
    protected void parseArgs(String ... argv) {
        Options.setDefaultOutputOptions();
        block39: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-g": {
                    Options.setDetailedOutputOptions();
                    continue block39;
                }
                case "-v": {
                    Options.set(Options.PrintOption.VERBOSE);
                    ((JdisEnvironment)this.environment).setVerboseFlag(true);
                    continue block39;
                }
                case "-sysinfo": {
                    Options.set(Options.PrintOption.SYSINFO);
                    continue block39;
                }
                case "-t": {
                    Options.set(Options.PrintOption.VERBOSE);
                    Options.set(Options.PrintOption.TRACE);
                    ((JdisEnvironment)this.environment).setVerboseFlag(true);
                    ((JdisEnvironment)this.environment).setTraceFlag(true);
                    continue block39;
                }
                case "-pc": {
                    Options.set(Options.PrintOption.PRINT_BCI);
                    continue block39;
                }
                case "-nc": {
                    Options.set(Options.PrintOption.NO_COMMENTS);
                    continue block39;
                }
                case "-hx": {
                    Options.set(Options.PrintOption.HEX);
                    continue block39;
                }
                case "-f": {
                    this.setFSDestination(FSOutput.FSDestination.FILE, ++i, argv);
                    continue block39;
                }
                case "-d": {
                    this.setFSDestination(FSOutput.FSDestination.DIR, ++i, argv);
                    continue block39;
                }
                case "-w": {
                    ((JdisEnvironment)this.environment).setIgnorePackage(true);
                    this.setFSDestination(FSOutput.FSDestination.DIR, ++i, argv);
                    continue block39;
                }
                case "-dls": {
                    ((JdisEnvironment)this.environment).setOutputs(new DualOutputStreamOutput());
                    continue block39;
                }
                case "-version": {
                    ((JdisEnvironment)this.environment).println(ProductInfo.FULL_VERSION, new Object[0]);
                    System.exit(0);
                }
                case "-": {
                    this.addStdIn();
                    continue block39;
                }
                case "-h": 
                case "-help": {
                    this.usage();
                    System.exit(0);
                }
                case "-best-effort": {
                    Options.set(Options.PrintOption.BEST_EFFORT);
                    continue block39;
                }
                case "-gg": {
                    Options.setDetailedOutputOptions();
                    Options.set(Options.PrintOption.EXTRA_DETAILED_Output);
                    continue block39;
                }
                case "-table": {
                    Options.set(Options.PrintOption.TABLE);
                    continue block39;
                }
                default: {
                    if (arg.startsWith("-")) {
                        if (arg.startsWith("-drop")) {
                            if (this.parseParameters("-drop", arg, "DROP", Options.PrintOption.DROP_All)) continue block39;
                            this.usage();
                            System.exit(1);
                            continue block39;
                        }
                        if (arg.startsWith("-lnt")) {
                            if (this.parseParameters("-lnt", arg, "LINE_NUMBER_TABLE", Options.PrintOption.LINE_NUMBER_TABLE_All)) continue block39;
                            this.usage();
                            System.exit(1);
                            continue block39;
                        }
                        if (arg.startsWith("-lvt")) {
                            if (this.parseParameters("-lvt", arg, "LOCAL_VARIABLE", Options.PrintOption.LOCAL_VARIABLE_All)) continue block39;
                            this.usage();
                            System.exit(1);
                            continue block39;
                        }
                        ((JdisEnvironment)this.environment).error("err.invalid_option", arg);
                        this.usage();
                        System.exit(1);
                        continue block39;
                    }
                    this.fileList.add(new FileInput(arg));
                }
            }
        }
        if (this.fileList.isEmpty()) {
            this.usage();
            System.exit(1);
        }
    }

    private boolean parseParameters(String option, String parameters, String optPrefix, Options.PrintOption blankOption) {
        if ((parameters = parameters.substring(option.length())).isBlank()) {
            if (!blankOption.isActive()) {
                ((JdisEnvironment)this.environment).error("err.option.unsupported", option + ":all");
                return false;
            }
            blankOption.apply();
        } else if (parameters.matches("^[:=-]+.*")) {
            parameters = parameters.substring(1);
            String[] prmArray = parameters.split(",");
            for (int i = 0; i < prmArray.length; ++i) {
                Options.PrintOption printOption = Options.PrintOption.getStringFlag(optPrefix, prmArray[i]);
                if (printOption == null || !printOption.name().startsWith(optPrefix)) {
                    ((JdisEnvironment)this.environment).error("err.invalid_parameter_of_option", prmArray[i], option);
                    return false;
                }
                if (!printOption.isActive()) {
                    ((JdisEnvironment)this.environment).error("err.option.unsupported", "%s:%s".formatted(option, prmArray[i]));
                    return false;
                }
                printOption.apply();
                if (!printOption.equals((Object)blankOption)) continue;
                return true;
            }
        } else {
            ((JdisEnvironment)this.environment).error("err.option.unsupported", option + parameters);
            return false;
        }
        return true;
    }
}

