/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AnnotationElement;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.ExceptionData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.ParameterAnnotationData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.notations.Signature;
import org.openjdk.asmtools.jdis.notations.Type;

public class MethodData
extends MemberData<ClassData> {
    protected int name_cpx;
    protected int descriptor_cpx;
    protected ArrayList<MethodParameterData> methodParameters;
    protected ParameterAnnotationData visibleParameterAnnotations;
    protected ParameterAnnotationData invisibleParameterAnnotations;
    protected AnnotationElement.AnnotationValue defaultAnnotation;
    protected ExceptionData exceptions;
    private CodeData code;
    private ParameterAnnotationsSizes parameterAnnotationsSizes = null;

    public MethodData(ClassData classData) {
        super(classData);
        this.tableToken = TableFormatModel.Token.METHOD_DATA;
        this.memberType = "MethodData";
        this.setCommentOffset(classData.pool.getCommentOffset());
        this.methodParameters = null;
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        boolean handled = true;
        switch (attributeTag) {
            case ATT_Code: {
                this.code = new CodeData(this);
                this.code.read(in, attributeLength);
                break;
            }
            case ATT_Signature: {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", "Signature", "method_info");
                }
                this.setSignature(new SignatureData((ClassData)this.data).read(in, attributeLength));
                break;
            }
            case ATT_Exceptions: {
                this.exceptions = new ExceptionData((ClassData)this.data).read(in, attributeLength);
                break;
            }
            case ATT_MethodParameters: {
                this.readMethodParameters(in);
                break;
            }
            case ATT_RuntimeVisibleParameterAnnotations: 
            case ATT_RuntimeInvisibleParameterAnnotations: {
                boolean invisible = attributeTag == EAttribute.ATT_RuntimeInvisibleParameterAnnotations;
                ParameterAnnotationData<MethodData> parameterAnnotationData = new ParameterAnnotationData<MethodData>(this, invisible);
                parameterAnnotationData.read(in);
                if (invisible) {
                    this.invisibleParameterAnnotations = parameterAnnotationData;
                    break;
                }
                this.visibleParameterAnnotations = parameterAnnotationData;
                break;
            }
            case ATT_AnnotationDefault: {
                this.defaultAnnotation = AnnotationElement.readValue(in, (ClassData)this.data, false);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.descriptor_cpx = in.readUnsignedShort();
        this.environment.traceln(() -> "MethodData: {modifiers[%d]}:%s name[%d]=%s signature[%d]=%s".formatted(this.access, EModifier.asNames(this.access, ClassFileContext.METHOD).isEmpty() ? "<none>" : Boolean.valueOf(EModifier.asNames(this.access, ClassFileContext.METHOD).isEmpty()), this.name_cpx, ((ClassData)this.data).pool.getString(this.name_cpx, index -> "???"), this.descriptor_cpx, ((ClassData)this.data).pool.getString(this.descriptor_cpx, index -> "???")));
        this.readAttributes(in);
    }

    private void readMethodParameters(DataInputStream in) throws IOException {
        int num_params = in.readUnsignedByte();
        this.environment.traceln(() -> "MethodParametersAttr[%d]".formatted(num_params));
        this.methodParameters = new ArrayList(num_params);
        for (int i = 0; i < num_params; ++i) {
            short paramNameCpx = (short)in.readUnsignedShort();
            int paramAccess = in.readUnsignedShort();
            this.environment.traceln("()->MethodParameter[%d] = { name[%d]: \"%s\" modifiers[%d]: %s}".formatted(i, paramNameCpx, this.pool.getString(paramNameCpx, index -> "???"), paramAccess, EModifier.asNames(paramAccess, ClassFileContext.METHOD)), new Object[0]);
            this.methodParameters.add(i, new MethodParameterData(paramNameCpx, paramAccess));
        }
    }

    private ParameterAnnotationsSizes ParameterAnnotationsSizes() {
        if (this.parameterAnnotationsSizes == null) {
            this.parameterAnnotationsSizes = new ParameterAnnotationsSizes(this.visibleParameterAnnotations != null ? this.visibleParameterAnnotations.numParameters() : 0, this.invisibleParameterAnnotations != null ? this.invisibleParameterAnnotations.numParameters() : 0);
        }
        return this.parameterAnnotationsSizes;
    }

    private boolean hasAnnotationParameters() {
        return this.ParameterAnnotationsSizes().hasParameterAnnotations() || this.methodParameters != null && this.methodParameters.size() > 0;
    }

    private boolean hasDefaultAnnotation() {
        return this.defaultAnnotation != null;
    }

    public void printMethodParameters() throws IOException {
        if (this.hasAnnotationParameters()) {
            this.incIndent();
            int totalWidth = this.printProgramCounter ? 7 : 5;
            int pNumSize = this.methodParameters != null ? this.methodParameters.size() : 0;
            int maxParams = Math.max(pNumSize, this.parameterAnnotationsSizes.invisibleParameterAnnotationsCount());
            maxParams = Math.max(this.parameterAnnotationsSizes.visibleParameterAnnotationsCount(), maxParams);
            String[] paramNames = this.getPrintableParameterNames(maxParams);
            for (int paramNum = 0; paramNum < maxParams; ++paramNum) {
                boolean hasAnnotations;
                ArrayList<AnnotationData> visAnnotationDataList = this.visibleParameterAnnotations != null && paramNum < this.parameterAnnotationsSizes.visibleParameterAnnotationsCount() ? this.visibleParameterAnnotations.get(paramNum) : null;
                ArrayList<AnnotationData> invisAnnotationDataList = this.invisibleParameterAnnotations != null && paramNum < this.parameterAnnotationsSizes.invisibleParameterAnnotationsCount() ? this.invisibleParameterAnnotations.get(paramNum) : null;
                MethodParameterData methodParameterData = this.methodParameters != null ? this.methodParameters.get(paramNum) : null;
                boolean bl = hasAnnotations = visAnnotationDataList != null || invisAnnotationDataList != null;
                if (methodParameterData == null && !hasAnnotations) continue;
                int annotOffset = 3;
                this.printIndent(this.PadRight("%2d: ".formatted(paramNum), totalWidth));
                if (methodParameterData != null) {
                    this.printPadRight(paramNames[paramNum], annotOffset);
                }
                this.printAnnotationDataList(visAnnotationDataList, annotOffset);
                this.printAnnotationDataList(invisAnnotationDataList, annotOffset);
                this.println();
            }
            this.decIndent();
        }
    }

    private void printAnnotationDataList(List<AnnotationData> annotationDataList, int offset) throws IOException {
        if (annotationDataList != null) {
            for (AnnotationData annot : annotationDataList) {
                this.println().print(this.enlargedIndent(offset));
                annot.setElementState(MemberData.AnnotationElementState.PARAMETER_ANNOTATION).setOffset(offset + this.getIndentSize()).print();
            }
        }
    }

    private String[] getPrintableParameterNames(int maxParams) {
        String[] names = new String[maxParams];
        if (this.methodParameters != null) {
            int paramNum = 0;
            while (paramNum < maxParams) {
                MethodParameterData methodParameterData = this.methodParameters.get(paramNum);
                names[paramNum] = JasmTokens.Token.PARAM_NAME.parseKey() + "{ ";
                if (this.printCPIndex) {
                    int n = paramNum;
                    names[n] = names[n] + "#%d ".formatted(methodParameterData.name_cpx);
                    if (!this.skipComments && methodParameterData.name_cpx != 0) {
                        int n2 = paramNum;
                        names[n2] = names[n2] + "/* %s */ ".formatted(((ClassData)this.data).pool.getString(methodParameterData.name_cpx, index -> "#" + index));
                    }
                    if (methodParameterData.access != 0) {
                        int n3 = paramNum;
                        names[n3] = names[n3] + EModifier.asKeywords(methodParameterData.access, ClassFileContext.METHOD_PARAMETERS);
                    }
                } else {
                    if (methodParameterData.name_cpx != 0) {
                        int n = paramNum;
                        names[n] = names[n] + ((ClassData)this.data).pool.getString(methodParameterData.name_cpx, index -> "#" + index) + " ";
                    } else {
                        int n = paramNum;
                        names[n] = names[n] + "#0 ";
                    }
                    if (methodParameterData.access != 0) {
                        int n = paramNum;
                        names[n] = names[n] + EModifier.asKeywords(methodParameterData.access, ClassFileContext.METHOD_PARAMETERS);
                    }
                }
                int n = paramNum++;
                names[n] = names[n] + "}";
            }
        }
        return names;
    }

    private String getMethodModifiers() {
        return EModifier.asKeywords(this.access, ClassFileContext.METHOD).concat(this.getPseudoFlagsAsString());
    }

    @Override
    protected void jasmPrint(int index, int size) throws IOException {
        Pair<String, String> jasmSignInfo;
        boolean noExtraInfo;
        boolean isSignaturePrintable = this.signature != null && this.signature.isPrintable();
        boolean tableSignatureFormat = isSignaturePrintable && this.signature.isTableOutput();
        boolean hasExceptions = this.exceptions != null;
        boolean hasCode = this.code != null;
        boolean hasCodeInfo = hasCode || this.hasAnnotationParameters() || hasExceptions;
        boolean bl = noExtraInfo = !hasCodeInfo && !tableSignatureFormat;
        if (index > 0) {
            this.println();
        }
        this.printSysInfo();
        super.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
        super.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
        String methSignature = this.getMethodModifiers();
        methSignature = methSignature.concat(JasmTokens.Token.METHODREF.parseKey());
        methSignature = this.PadRight(methSignature, Math.max(methSignature.length() + 1, TableFormatModel.Token.SIGNATURE.parseKey().length() + this.getIndentSize() * 2));
        int keywordPadding = methSignature.length() - this.getIndentSize();
        Pair<String, String> pair = jasmSignInfo = isSignaturePrintable ? this.signature.getJasmPrintInfo(i -> this.pool.inRange((int)i)) : new Pair<String, String>("", "");
        if (this.printCPIndex) {
            methSignature = methSignature.concat("#%d:#%d".formatted(this.name_cpx, this.descriptor_cpx)).concat((String)jasmSignInfo.first);
            if (noExtraInfo && !this.hasDefaultAnnotation()) {
                methSignature = methSignature.concat(";");
            }
            if (this.skipComments) {
                if (this.defaultAnnotation != null) {
                    this.printIndent(this.PadRight(methSignature, this.getCommentOffset()));
                } else {
                    this.printIndent(methSignature);
                }
            } else {
                this.printIndent(this.PadRight(methSignature, this.getCommentOffset()));
                String comment = (this.defaultAnnotation != null ? " /* " : " // ").concat("%s:%s".formatted(((ClassData)this.data).pool.getName(this.name_cpx), ((ClassData)this.data).pool.getName(this.descriptor_cpx), jasmSignInfo.second)).concat((String)jasmSignInfo.second).concat(this.defaultAnnotation != null ? " */ " : " ");
                this.print(comment);
            }
        } else {
            methSignature = methSignature.concat(((ClassData)this.data).pool.getName(this.name_cpx) + ":").concat(((ClassData)this.data).pool.getName(this.descriptor_cpx)).concat((String)jasmSignInfo.second);
            if (noExtraInfo && !this.hasDefaultAnnotation()) {
                methSignature = methSignature.concat(";");
            }
            this.printIndent(methSignature);
        }
        if (this.hasDefaultAnnotation()) {
            this.defaultAnnotation.incIndent().setCommentOffset(this.getIndentSize() - this.getIndentStep());
            this.defaultAnnotation.setElementState(MemberData.AnnotationElementState.HAS_DEFAULT_VALUE);
            this.defaultAnnotation.print();
            if (!hasCodeInfo) {
                this.print(!tableSignatureFormat ? ";" : ",");
            }
        }
        if (tableSignatureFormat) {
            this.println();
            this.signature.disableNewLine().setKeywordPadding(keywordPadding).incIndent().setCommentOffset(this.getCommentOffset() - this.getIndentStep());
            this.signature.terminateMethodSignature(!hasExceptions);
            this.signature.print();
        }
        if (this.exceptions != null) {
            this.println();
            this.exceptions.setKeywordPadding(keywordPadding).incIndent().setCommentOffset(this.getCommentOffset() - this.getIndentStep());
            this.exceptions.print();
        } else {
            this.println();
        }
        if (this.code != null) {
            this.code.setCommentOffset(this.getCommentOffset());
            this.code.print();
        } else if (this.hasAnnotationParameters()) {
            this.printMethodParameters();
        }
    }

    @Override
    public void tablePrint(int index, int size) throws IOException {
        this.jasmPrint(index, size);
    }

    @Override
    protected void printSysInfo() {
        if (this.sysInfo) {
            int paramCount = EModifier.isStatic(this.access) ? 0 : 1;
            Object prefix = this.getIndentString() + " *  ";
            String methodModifiers = this.getMethodModifiers();
            Type signatureType = this.signature != null ? this.signature.getSignatureType() : new Signature(this.environment.getLogger(), this.descriptor_cpx).getType(this.pool);
            String methodName = ((ClassData)this.data).pool.getString(this.name_cpx, ConstantPool.funcInvalidCPIndex);
            boolean isConstructor = methodName.equals("<init>");
            String methodSignature = signatureType.toString();
            if (signatureType instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)signatureType;
                paramCount += methodType.paramTypes.size();
            }
            int i = 0;
            if (isConstructor) {
                methodName = ((ClassData)this.data).getClassName();
                methodSignature = methodSignature.substring(methodSignature.indexOf("("));
            } else {
                i = methodSignature.indexOf(40);
            }
            methodName = methodSignature.substring(0, i).concat(methodName).concat(methodSignature.substring(i)).replaceAll("/", ".");
            String descriptor = ((ClassData)this.data).pool.getString(this.descriptor_cpx, ConstantPool.funcInvalidCPIndex);
            this.printIndentLn("/**");
            this.println((String)prefix + methodModifiers + methodName);
            prefix = ((String)prefix).concat(this.getIndentString());
            this.println((String)prefix + "descriptor: " + descriptor);
            if (this.signature != null) {
                this.println((String)prefix + "signature:  " + ((ClassData)this.data).pool.getString(this.signature.getCPIndex(), ConstantPool.funcInvalidCPIndex));
            }
            this.println((String)prefix + "flags: (0x%04x) %s".formatted(this.access, EModifier.asNames(this.access, ClassFileContext.METHOD)));
            this.println((String)prefix + "stack: %d, locals: %d, args_size: %d".formatted(this.code.max_stack, this.code.max_locals, paramCount));
            this.printIndentLn(" */");
        }
    }

    private record ParameterAnnotationsSizes(int visibleParameterAnnotationsCount, int invisibleParameterAnnotationsCount) {
        boolean hasParameterAnnotations() {
            return this.visibleParameterAnnotationsCount > 0 || this.invisibleParameterAnnotationsCount > 0;
        }
    }

    static class MethodParameterData {
        public int access;
        public int name_cpx;

        public MethodParameterData(int name, int access) {
            this.access = access;
            this.name_cpx = name;
        }
    }
}

