/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.TableFormatModel;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.SignatureData;

public class RecordData
extends MemberData<ClassData> {
    private List<Component> components;

    public RecordData(ClassData classData) {
        super(classData);
        this.tableToken = TableFormatModel.Token.RECORD_DATA;
    }

    public RecordData read(DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        this.environment.traceln("components=" + count, new Object[0]);
        this.components = new ArrayList<Component>(count);
        for (int i = 0; i < count; ++i) {
            this.components.add(new Component((ClassData)this.data).read(in));
        }
        return this;
    }

    @Override
    public void print() throws IOException {
        int count = this.components.size();
        if (count > 0) {
            boolean isExtendedPrintingSupported = this.tableToken.isExtendedPrintingSupported();
            this.printIndentLn("%s {".formatted(JasmTokens.Token.RECORD.parseKey()));
            for (int i = 0; i < count; ++i) {
                Component cn = this.components.get(i);
                cn.setCommentOffset(this.getCommentOffset() + this.getIndentSize()).incIndent();
                if (isExtendedPrintingSupported && this.isTableOutput()) {
                    cn.tablePrint(i, count);
                    continue;
                }
                cn.jasmPrint(i, count);
            }
            this.printIndentLn("}");
        }
    }

    public static class Component
    extends MemberData<ClassData> {
        private int name_cpx;
        private int descriptor_cpx;

        public Component(ClassData classData) {
            super(classData);
            this.memberType = "RecordData";
        }

        @Override
        protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
            boolean handled = true;
            if (attributeTag == EAttribute.ATT_Signature) {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", "Signature", "record_component_info");
                }
                this.signature = new SignatureData((ClassData)this.data).read(in, attributeLength);
            } else {
                handled = false;
            }
            return handled;
        }

        public Component read(DataInputStream in) throws IOException {
            this.name_cpx = in.readUnsignedShort();
            this.descriptor_cpx = in.readUnsignedShort();
            this.environment.traceln("RecordComponent: name[%d]=%s descriptor[%d]=%s".formatted(this.name_cpx, ((ClassData)this.data).pool.getString(this.name_cpx, index -> "?"), this.descriptor_cpx, ((ClassData)this.data).pool.getString(this.descriptor_cpx, index -> "?")), new Object[0]);
            this.readAttributes(in);
            return this;
        }

        @Override
        public void jasmPrint(int index, int size) throws IOException {
            boolean printSignature = this.signature != null && this.signature.isPrintable() && this.tableFormat;
            super.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
            super.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
            int keywordPadding = this.getPrintAttributeKeyPadding() + this.getIndentSize() * 2 - 2;
            String prefix = this.PadRight(this.Indent(this.getPseudoFlagsAsString()).concat(JasmTokens.Token.COMPONENT.parseKey()), keywordPadding);
            this.printVar(new StringBuilder(prefix), null, printSignature ? ":" : ";", this.name_cpx, this.descriptor_cpx, -1);
            if (printSignature) {
                this.signature.setKeywordPadding(keywordPadding -= this.getIndentSize() + 2).incIndent().incIndent().setCommentOffset(this.getCommentOffset() - this.getIndentStep() * 2 - 2);
                this.signature.print();
            }
        }

        @Override
        public void tablePrint(int index, int size) throws IOException {
            this.jasmPrint(index, size);
        }
    }
}

