/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.Container;
import org.openjdk.asmtools.jdis.StackMapData;

public class StackMapTable
extends Container<StackMapData, CodeData> {
    private final EAttribute attribute;
    protected final ArrayList<Boolean> wrappers;
    private String jasmHeader = ": number_of_entries = %d";
    private String intLine = "n/a";
    private String strLine = "n/a";
    private int shift;

    public StackMapTable(EAttribute attribute, CodeData owner, int initialCapacity) {
        super(owner, StackMapData.class, initialCapacity);
        this.wrappers = new ArrayList(initialCapacity);
        this.attribute = attribute;
        switch (this.attribute) {
            case ATT_StackMap: {
                this.shift = owner.calculateInlinedTitleShift(JasmTokens.Token.LOCALSMAP.parseKey());
                this.jasmHeader = JasmTokens.Token.STACKMAP_HEADER.parseKey() + this.jasmHeader;
                break;
            }
            case ATT_StackMapTable: {
                this.shift = owner.calculateInlinedTitleShift(JasmTokens.Token.FRAMETYPE.parseKey());
                this.jasmHeader = JasmTokens.Token.STACKMAPTABLE_HEADER.parseKey() + this.jasmHeader;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.attribute);
            }
        }
        this.intLine = "%" + this.shift + "s = %-3d";
        this.strLine = "%" + this.shift + "s = %s";
    }

    public void add(StackMapData element, boolean isWrapper) throws IOException {
        element.setPrintParticles(this.intLine, this.strLine, this.shift);
        super.add(element);
        this.wrappers.add(isWrapper);
    }

    public int real_size() {
        int mWrappers = (int)this.wrappers.stream().filter(Boolean::booleanValue).count();
        return this.elements.size() - mWrappers;
    }

    @Override
    public void print() throws IOException {
        int size = this.size();
        if (size > 0) {
            ((StackMapData)this.elements.get(0)).setHeader(this.jasmHeader.formatted(this.real_size()));
            this.setMaxPrintSize(this.getPrintSize());
            for (int i = 0; i < size; ++i) {
                StackMapData element = (StackMapData)this.elements.get(i);
                element.setCommentOffset(this.getCommentOffset());
                element.jasmPrint(i, size);
            }
        }
    }
}

