/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.PreferencesPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorPrefsPane
extends PreferencesPane {
    private JPanel inputColors;
    private UIFactory uif;
    private I18NResourceBundle i18n;

    public ColorPrefsPane(UIFactory uifactory) {
        this.uif = uifactory;
        this.i18n = I18NResourceBundle.getBundleForClass(ColorPrefsPane.class);
        this.setLayout(new GridBagLayout());
        Insets in = new Insets(2, 3, 2, 3);
        GridBagConstraints c = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, in, 3, 5);
        this.inputColors = new JPanel();
        this.inputColors.setBorder(this.uif.createTitledBorder("colorprefs.inputcolors"));
        this.inputColors.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, in, 3, 5);
        UIFactory.Colors[] colors = UIFactory.Colors.values();
        for (int i = 0; i < colors.length; ++i) {
            if (!colors[i].isConfigurable()) continue;
            String colorName = colors[i].getPreferencesName();
            JLabel label = this.uif.createLabel("colorprefs." + colorName);
            JButton button = this.uif.createColorChooseButton(colorName, label, null);
            button.addActionListener(new ActionListener(){
                private String title;
                private JButton button;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color newColor = JColorChooser.showDialog(ColorPrefsPane.this, this.title, this.button.getBackground());
                    if (newColor != null) {
                        this.button.setBackground(newColor);
                    }
                }

                public ActionListener init(String title, JButton button) {
                    this.title = title;
                    this.button = button;
                    return this;
                }
            }.init(this.i18n.getString("colorprefs." + colorName + ".cctitle"), button));
            gbc.gridx = 0;
            gbc.weightx = 0.3;
            gbc.gridy = i;
            this.inputColors.add((Component)label, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.gridy = i;
            this.inputColors.add((Component)button, gbc);
        }
        this.add((Component)this.inputColors, c);
        JButton defaults = this.uif.createButton("colorprefs.setdefaults", e -> {
            Component[] components;
            for (Component c1 : components = this.inputColors.getComponents()) {
                if (!(c1 instanceof JButton)) continue;
                JButton b = (JButton)c1;
                String name = b.getName();
                b.setBackground(Color.decode(this.i18n.getString("colorprefs." + name + ".defvalue")));
            }
        });
        c.anchor = 13;
        c.fill = 0;
        this.add((Component)defaults, c);
    }

    @Override
    public String getText() {
        return this.i18n.getString("colorprefs.name");
    }

    @Override
    public void save(Map<String, String> m) {
        Component[] components;
        super.save(m);
        for (Component c : components = this.inputColors.getComponents()) {
            if (!(c instanceof JButton)) continue;
            JButton b = (JButton)c;
            UIFactory.Colors.getColorByPreferencesName(c.getName());
            String colorCode = String.valueOf(b.getBackground().getRGB());
            UIFactory.setColorByName(b.getName(), b.getBackground());
            m.put(b.getName(), colorCode);
        }
    }
}

