/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;

public abstract class TimeoutHandler {
    protected final PrintWriter log;
    protected final File outputDir;
    protected final File testJdk;
    private long timeout;

    public TimeoutHandler(PrintWriter log, File outputDir, File testJdk) {
        this(log, outputDir, testJdk.toPath());
    }

    public TimeoutHandler(PrintWriter log, File outputDir, Path testJdk) {
        this.log = log;
        this.outputDir = outputDir;
        this.testJdk = testJdk.toFile();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTimeout(Process proc) {
        this.log.println("Timeout information:");
        String startedAt = Utils.HOUR_MIN_SEC_MS_FORMAT.format(ZonedDateTime.now());
        this.log.println("[" + startedAt + "] starting timeout handler action(s)");
        long pid = proc.pid();
        Alarm a = this.timeout <= 0L ? Alarm.NONE : Alarm.scheduleInterrupt(this.timeout, TimeUnit.SECONDS, this.log, Thread.currentThread());
        try {
            this.runActions(proc, pid);
        }
        catch (InterruptedException ex) {
            a.cancel();
            this.log.println("Timeout handler interrupted: ");
            ex.printStackTrace(this.log);
        }
        finally {
            String endedAt = Utils.HOUR_MIN_SEC_MS_FORMAT.format(ZonedDateTime.now());
            this.log.println("[" + endedAt + "] timeout handler action(s) completed");
            a.cancel();
        }
        this.log.println("--- Timeout information end.");
    }

    protected abstract void runActions(Process var1, long var2) throws InterruptedException;
}

