/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class JDKOpts {
    private final MergeHandler mergeHandler = new MergeHandler();
    private String pending;
    private static final char COMMA = ',';
    private static final char EQUALS = '=';
    private static final char NUL = '\u0000';
    private static final char PATHSEP = File.pathSeparatorChar;

    public static boolean hasFollowingArg(String opt) {
        for (Option option : Option.values()) {
            for (String name : option.names) {
                if (!opt.equals(name) || name.endsWith(":") || name.endsWith("=")) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> toList() {
        return Collections.unmodifiableList(this.mergeHandler.opts);
    }

    public void addAll(List<String> opts) {
        for (String opt : opts) {
            this.add(opt);
        }
    }

    public void addAll(String ... opts) {
        for (String opt : opts) {
            this.add(opt);
        }
    }

    public void add(String opt) {
        if (this.pending != null) {
            this.mergeHandler.handleOption(this.pending, opt);
            this.pending = null;
        } else if (JDKOpts.hasFollowingArg(opt)) {
            this.pending = opt;
        } else {
            this.mergeHandler.handleOption(opt);
        }
    }

    public void addPath(String opt, SearchPath path) {
        if (path != null && !path.isEmpty()) {
            if (opt.endsWith(":")) {
                this.add(opt + path);
            } else {
                this.add(opt);
                this.add(path.toString());
            }
        }
    }

    public void addAllPatchModules(SearchPath patchPath) {
        if (patchPath != null) {
            for (Path dir : patchPath.asList()) {
                List<Path> subdirs = FileUtils.listFiles(dir);
                if (subdirs == null) continue;
                Collections.sort(subdirs);
                for (Path subdir : subdirs) {
                    if (!Files.isDirectory(subdir, new LinkOption[0])) continue;
                    String moduleName = subdir.getFileName().toString();
                    this.mergeHandler.handleOption(Option.PATCH_MODULE, "--patch-module", moduleName + "=" + subdir);
                }
            }
        }
    }

    public static enum Option {
        ADD_EXPORTS("--add-exports"),
        ADD_EXPORTS_PRIVATE("--add-exports-private"),
        ADD_MODULES("--add-modules"),
        ADD_OPENS("--add-opens"),
        ADD_READS("--add-reads"),
        CLASS_PATH("--class-path", "-classpath", "-cp"),
        LIMIT_MODULES("--limit-modules"),
        MODULE_PATH("--module-path", "-p"),
        MODULE_SOURCE_PATH("--module-source-path"),
        PATCH_MODULE("--patch-module"),
        SOURCE_PATH("--source-path", "-sourcepath");

        final String[] names;

        private Option(String ... names) {
            this.names = names;
        }
    }

    private static class MergeHandler
    extends OptionHandler {
        private final List<String> opts = new ArrayList<String>();
        private final Map<String, Integer> index = new HashMap<String, Integer>();

        MergeHandler() {
        }

        @Override
        protected void handleOption(Option option, String opt, String arg) {
            switch (option) {
                case ADD_EXPORTS: {
                    this.updateOptWhitespaceArg("--add-exports", arg, '=', ',');
                    break;
                }
                case ADD_EXPORTS_PRIVATE: 
                case ADD_OPENS: {
                    this.updateOptWhitespaceArg("--add-opens", arg, '=', ',');
                    break;
                }
                case ADD_MODULES: {
                    this.updateOptWhitespaceArg("--add-modules", arg, '\u0000', ',');
                    break;
                }
                case ADD_READS: {
                    this.updateOptWhitespaceArg("--add-reads", arg, '=', ',');
                    break;
                }
                case CLASS_PATH: {
                    this.updateOptWhitespaceArg("-classpath", arg, '\u0000', PATHSEP);
                    break;
                }
                case LIMIT_MODULES: {
                    this.updateOptWhitespaceArg("--limit-modules", arg, '\u0000', ',');
                    break;
                }
                case MODULE_PATH: {
                    this.updateOptWhitespaceArg("--module-path", arg, '\u0000', PATHSEP);
                    break;
                }
                case MODULE_SOURCE_PATH: {
                    this.updateOptWhitespaceArg("--module-source-path", arg, '\u0000', PATHSEP);
                    break;
                }
                case PATCH_MODULE: {
                    this.updateOptWhitespaceArg("--patch-module", arg, '=', PATHSEP);
                    break;
                }
                case SOURCE_PATH: {
                    this.updateOptWhitespaceArg("-sourcepath", arg, '\u0000', PATHSEP);
                }
            }
        }

        @Override
        protected void handleUnknown(String opt) {
            this.opts.add(opt);
        }

        private void updateOptAdjacentArg(String opt, char keySep, char valSep) {
            int i = opt.indexOf(keySep);
            String key = opt.substring(0, i + 1);
            String optValues = opt.substring(i + 1);
            Integer pos = this.index.get(key);
            if (pos == null) {
                pos = this.opts.size();
                this.opts.add(opt);
                this.index.put(key, pos);
            } else {
                LinkedHashSet<String> allValues = new LinkedHashSet<String>();
                String[] oldValues = this.opts.get(pos).substring(i + 1).split(String.valueOf(valSep));
                allValues.addAll(List.of(oldValues));
                allValues.addAll(List.of(optValues.split(String.valueOf(valSep))));
                StringBuilder sb = new StringBuilder(key);
                for (String v : allValues) {
                    if (sb.length() > key.length()) {
                        sb.append(valSep);
                    }
                    sb.append(v);
                }
                this.opts.set(pos, sb.toString());
            }
        }

        private void updateOptWhitespaceArg(String opt, String arg, char keySep, char valueSep) {
            List<String> argValues;
            String argKey;
            if (keySep != '\u0000' && arg.indexOf(keySep) != -1) {
                argKey = StringUtils.beforePart(arg, keySep);
                argValues = StringUtils.split(StringUtils.afterPart(arg, keySep), valueSep);
            } else {
                argKey = null;
                argValues = StringUtils.split(arg, valueSep);
            }
            String indexKey = argKey == null ? opt : opt + "=" + argKey;
            Integer pos = this.index.get(indexKey);
            if (pos == null) {
                pos = this.opts.size();
                this.opts.add(opt);
                this.opts.add(MergeHandler.join(argKey, keySep, argValues, valueSep));
                this.index.put(indexKey, pos);
            } else {
                LinkedHashSet<String> allValues = new LinkedHashSet<String>();
                String old = this.opts.get(pos + 1);
                List<String> oldValues = StringUtils.split(argKey == null ? old : StringUtils.afterPart(old, keySep), valueSep);
                allValues.addAll(oldValues);
                allValues.addAll(argValues);
                this.opts.set(pos + 1, MergeHandler.join(argKey, keySep, allValues, valueSep));
            }
        }

        static String join(String key, char keySep, Collection<String> values, char valSep) {
            StringBuilder sb = new StringBuilder();
            if (key != null) {
                sb.append(key).append(keySep);
            }
            boolean needSep = false;
            for (String v : values) {
                if (needSep) {
                    sb.append(valSep);
                }
                sb.append(v);
                needSep = true;
            }
            return sb.toString();
        }
    }

    public static abstract class OptionHandler {
        public void handleOptions(String ... opts) {
            this.handleOptions(List.of(opts));
        }

        public void handleOptions(List<String> opts) {
            Iterator<String> iter = opts.iterator();
            while (iter.hasNext()) {
                String opt = iter.next();
                this.handleOption(opt, iter);
            }
        }

        void handleOption(String opt) {
            this.handleOption(opt, Collections.emptyIterator());
        }

        void handleOption(String opt, String arg) {
            this.handleOption(opt, Collections.singleton(arg).iterator());
        }

        void handleOption(String opt, Iterator<String> rest) {
            for (Option o : Option.values()) {
                for (String name : o.names) {
                    if (name.startsWith("--")) {
                        if (opt.equals(name)) {
                            this.handleOption(o, opt, rest.next());
                            return;
                        }
                        if (!opt.startsWith(name + "=")) continue;
                        this.handleOption(o, opt, opt.substring(name.length() + 1));
                        return;
                    }
                    if (name.endsWith(":")) {
                        if (!opt.startsWith(name)) continue;
                        this.handleOption(o, opt, opt.substring(name.length()));
                        return;
                    }
                    if (!opt.equals(name)) continue;
                    this.handleOption(o, opt, rest.next());
                    return;
                }
            }
            this.handleUnknown(opt);
        }

        protected abstract void handleOption(Option var1, String var2, String var3);

        protected abstract void handleUnknown(String var1);
    }
}

