/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.config.GroupManager;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TestManager {
    private final TestFinder.ErrorHandler errHandler;
    private final PrintWriter out;
    private final Path baseDir;
    private Path reportDir;
    private Path workDir;
    boolean allowEmptyGroups = true;
    Map<Path, Entry> map = new TreeMap<Path, Entry>();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestManager.class);

    public TestManager(PrintWriter out, Path baseDir, TestFinder.ErrorHandler errHandler) {
        this.out = out;
        this.baseDir = baseDir.toAbsolutePath();
        this.errHandler = errHandler;
    }

    public void addTestSpecs(Collection<TestSpec> tests) throws Main.Fault {
        HashMap<Path, Path> rootDirCache = new HashMap<Path, Path>();
        for (TestSpec t : tests) {
            Path f = this.canon(t.file);
            if (!Files.exists(f, new LinkOption[0])) {
                throw new Main.Fault(i18n, "tm.cantFindFile", t.file);
            }
            Path rootDir = this.getRootDir(rootDirCache, f);
            if (rootDir == null) {
                throw new Main.Fault(i18n, "tm.cantDetermineTestSuite", t.file);
            }
            Entry e = this.getEntry(rootDir);
            if (f.equals(rootDir)) {
                e.all = true;
                e.tests.clear();
                continue;
            }
            if (e.all) continue;
            e.tests.add(new TestSpec(rootDir.relativize(f), t.id, t.query));
        }
    }

    public void addGroupSpecs(Collection<GroupSpec> groups) throws Main.Fault {
        for (GroupSpec g : groups) {
            Path rootDir = this.canon(g.dir == null ? this.baseDir : g.dir);
            if (!Files.exists(rootDir.resolve("TEST.ROOT"), new LinkOption[0])) {
                throw new Main.Fault(i18n, "tm.badGroupTestSuite", g);
            }
            Entry e = this.getEntry(rootDir);
            e.groups.add(g.groupName);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isMultiRun() {
        return this.map.size() > 1;
    }

    public Set<RegressionTestSuite> getTestSuites() throws Main.Fault {
        LinkedHashSet<RegressionTestSuite> set = new LinkedHashSet<RegressionTestSuite>();
        for (Entry e : this.map.values()) {
            if (e.testSuite == null) {
                try {
                    e.testSuite = RegressionTestSuite.open(e.rootDir.toFile(), this.errHandler);
                    if (!e.testSuite.getRootDir().toPath().equals(e.rootDir)) {
                        System.err.println("e.testSuite.getRootDir(): " + e.testSuite.getRootDir());
                        System.err.println("e.rootDir: " + e.rootDir);
                        System.err.println(e.testSuite.getRootDir().toPath().equals(e.rootDir));
                        throw new AssertionError();
                    }
                }
                catch (TestSuite.Fault f) {
                    throw new Main.Fault(i18n, "tm.cantOpenTestSuite", e.testSuite, f);
                }
            }
            set.add(e.testSuite);
        }
        return set;
    }

    public void setWorkDirectory(Path wd) {
        if (wd == null) {
            throw new NullPointerException();
        }
        if (this.workDir != null) {
            throw new IllegalStateException();
        }
        this.workDir = wd;
    }

    public Path getWorkDirectory() {
        if (this.workDir == null) {
            throw new IllegalStateException();
        }
        return this.workDir;
    }

    public WorkDirectory getWorkDirectory(RegressionTestSuite ts) throws Main.Fault {
        Entry e = this.map.get(ts.getRootDir().toPath());
        if (e == null) {
            throw new IllegalStateException();
        }
        if (e.workDir == null) {
            if (e.subdir == null && this.isMultiRun()) {
                this.initSubdirs();
            }
            Path wd = e.subdir == null ? this.workDir : this.workDir.resolve(e.subdir);
            File wdf = wd.toFile();
            try {
                e.workDir = WorkDirectory.isWorkDirectory(wdf) ? WorkDirectory.open(wdf, ts) : (Files.exists(wd, new LinkOption[0]) ? WorkDirectory.convert(wdf, ts) : WorkDirectory.create(wdf, ts));
            }
            catch (WorkDirectory.Fault | FileNotFoundException ex) {
                throw new Main.Fault(i18n, "tm.cantRead", wd.getFileName().toString(), ex);
            }
        }
        return e.workDir;
    }

    public void setReportDirectory(Path rd) {
        if (rd == null) {
            throw new NullPointerException();
        }
        if (this.reportDir != null) {
            throw new IllegalStateException();
        }
        this.reportDir = rd;
    }

    public Path getReportDirectory() {
        if (this.reportDir == null) {
            throw new IllegalStateException();
        }
        return this.reportDir;
    }

    public Path getReportDirectory(RegressionTestSuite ts) throws Main.Fault {
        Entry e = this.map.get(ts.getRootDir().toPath());
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (this.reportDir != null && e.reportDir == null) {
            if (e.subdir == null && this.isMultiRun()) {
                this.initSubdirs();
            }
            e.reportDir = e.subdir == null ? this.reportDir : this.reportDir.resolve(e.subdir);
        }
        return e.reportDir;
    }

    String getSubdirectory(RegressionTestSuite ts) throws Main.Fault {
        if (this.map.size() <= 1) {
            return null;
        }
        Entry e = this.map.get(ts.getRootDir().toPath());
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (e.subdir == null) {
            this.initSubdirs();
        }
        return e.subdir;
    }

    public Set<String> getTests(RegressionTestSuite ts) throws Main.Fault {
        Entry e = this.map.get(ts.getRootDir().toPath());
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (e.all) {
            return null;
        }
        WorkDirectory wd = this.getWorkDirectory(ts);
        LinkedHashSet<String> tests = new LinkedHashSet<String>();
        for (TestSpec test : e.tests) {
            String t = test.getTestPath();
            if (this.validatePath(wd, t)) {
                tests.add(t);
                continue;
            }
            throw new Main.Fault(i18n, "tm.notATest", test);
        }
        for (Path f : this.expandGroups(e)) {
            String test = TestManager.pathToString(e.rootDir.relativize(f));
            if (test.isEmpty()) {
                return null;
            }
            if (!this.validatePath(wd, test)) continue;
            tests.add(test);
        }
        if (tests.isEmpty() && (!this.allowEmptyGroups || e.groups.isEmpty())) {
            throw new NoTests();
        }
        return tests;
    }

    public List<String> getTestQueries(RegressionTestSuite ts) throws Main.Fault {
        Entry e = this.map.get(ts.getRootDir().toPath());
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (e.all) {
            return List.of();
        }
        LinkedHashMap<String, TestSpec> map = new LinkedHashMap<String, TestSpec>();
        for (TestSpec t2 : e.tests) {
            if (t2.query != null && Files.isDirectory(e.rootDir.resolve(t2.file), new LinkOption[0])) {
                throw new Main.Fault(i18n, "tm.invalidQuery", t2);
            }
            map.put(t2.getTestPath(), t2);
        }
        return map.values().stream().filter(t -> t.query != null).map(t -> t.getTestPath() + "?" + t.query).collect(Collectors.toList());
    }

    private boolean validatePath(WorkDirectory wd, String path) {
        try {
            TestResultTable trt = wd.getTestResultTable();
            if (trt.validatePath(path)) {
                if (path.matches(".*#[A-Za-z0-9-_]+")) {
                    return true;
                }
                File rootDir = wd.getTestSuite().getRootDir();
                File f = new File(rootDir, path);
                if (f.isDirectory()) {
                    return true;
                }
                TestResultTable.TreeIterator iter = trt.getIterator(new String[]{path}, new TestFilter[0]);
                while (iter.hasNext()) {
                    TestResult tr = iter.next();
                    String trp = tr.getDescription().getRootRelativePath();
                    if (!path.equals(trp)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (TestResult.Fault f) {
            return false;
        }
    }

    public Set<String> getGroups(RegressionTestSuite ts) throws Main.Fault {
        Entry e = this.map.get(ts.getRootDir().toPath());
        if (e == null) {
            throw new IllegalArgumentException();
        }
        return e.groups;
    }

    private Entry getEntry(Path rootDir) {
        Entry e = this.map.get(rootDir);
        if (e == null) {
            e = new Entry(rootDir);
            this.map.put(rootDir, e);
        }
        return e;
    }

    private Path getRootDir(Map<Path, Path> rootDirCache, Path file) {
        if (file == null) {
            return null;
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            return this.getRootDir(rootDirCache, file.getParent());
        }
        Path ts = rootDirCache.get(file);
        if (ts == null) {
            ts = Files.exists(file.resolve("TEST.ROOT"), new LinkOption[0]) ? file : this.getRootDir(rootDirCache, file.getParent());
            rootDirCache.put(file, ts);
        }
        return ts;
    }

    private void initSubdirs() throws Main.Fault {
        Object subdir;
        if (WorkDirectory.isWorkDirectory(this.workDir.toFile())) {
            throw new Main.Fault(i18n, "tm.workDirNotSuitableInMultiTestSuiteMode", new Object[0]);
        }
        HashSet<Object> subdirs = new HashSet<Object>();
        if (Files.exists(this.workDir, new LinkOption[0])) {
            if (!Files.isDirectory(this.workDir, new LinkOption[0])) {
                throw new Main.Fault(i18n, "tm.notADirectory", this.workDir);
            }
            for (Path f : FileUtils.listFiles(this.workDir)) {
                File tsr;
                Entry e;
                subdir = f.getFileName().toString();
                subdirs.add(subdir);
                if (!WorkDirectory.isUsableWorkDirectory(f.toFile()) || (e = this.map.get((tsr = this.getTestSuiteForWorkDirectory(f.toFile())).toPath())) == null) continue;
                e.subdir = subdir;
            }
        }
        for (Entry e : this.map.values()) {
            if (e.subdir != null) continue;
            subdir = e.rootDir.getFileName().toString();
            if (e.rootDir.getParent() != null) {
                subdir = e.rootDir.getParent().getFileName() + "_" + (String)subdir;
            }
            if (subdirs.contains(subdir)) {
                String sdn;
                int n = 0;
                while (subdirs.contains(sdn = (String)subdir + "_" + n)) {
                    ++n;
                }
                subdir = sdn;
            }
            e.subdir = subdir;
            subdirs.add(subdir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getTestSuiteForWorkDirectory(File wd) {
        File tsInfo = new File(new File(wd, "jtData"), "testsuite");
        try (FileInputStream in = new FileInputStream(tsInfo);){
            Properties p = new Properties();
            p.load(in);
            String tsr = p.getProperty("root");
            if (tsr == null) return new File("__UNKNOWN__");
            File file = new File(tsr);
            return file;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File("__UNKNOWN__");
    }

    private Set<Path> expandGroups(Entry e) throws Main.Fault {
        try {
            LinkedHashSet<Path> results = new LinkedHashSet<Path>();
            GroupManager gm = e.testSuite.getGroupManager(this.out);
            if (gm.invalid()) {
                boolean reportErrorIfInvalidGroups;
                Version v = e.testSuite.getRequiredVersion();
                boolean bl = reportErrorIfInvalidGroups = v.version != null && v.compareTo(new Version("5.1 b01")) >= 0;
                if (reportErrorIfInvalidGroups) {
                    throw new Main.Fault(i18n, "tm.invalidGroups", new Object[0]);
                }
            }
            for (String group : e.groups) {
                try {
                    results.addAll(gm.getFiles(group));
                }
                catch (GroupManager.InvalidGroup ex) {
                    throw new Main.Fault(i18n, "tm.invalidGroup", group);
                }
            }
            return results;
        }
        catch (IOException ex) {
            throw new Main.Fault(i18n, "tm.cantReadGroups", e.testSuite.getRootDir(), ex);
        }
    }

    private Path canon(Path file) {
        Path f = file.isAbsolute() ? file : this.baseDir.resolve(file);
        try {
            return f.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return TestManager.getNormalizedFile(f);
        }
    }

    private static Path getNormalizedFile(Path f) {
        return f.toAbsolutePath().normalize();
    }

    private static String pathToString(Path p) {
        return p.toString().replace(File.separatorChar, '/');
    }

    public static class TestSpec {
        public final Path file;
        public final String id;
        public final String query;
        static Pattern fileIdQueryPtn = Pattern.compile("(?<file>.+?)(#(?<id>[A-Za-z0-9-_]+))?(\\?(?<query>.*))?");

        public static boolean isTestSpec(String s) {
            return fileIdQueryPtn.matcher(s).matches();
        }

        public static TestSpec of(String s) {
            Matcher m = fileIdQueryPtn.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException(s);
            }
            Path file = Path.of(m.group("file"), new String[0]);
            String id = m.group("id");
            String query = m.group("query");
            return new TestSpec(file, id, query);
        }

        private TestSpec(Path file, String id, String query) {
            this.file = Objects.requireNonNull(file);
            this.id = id;
            this.query = query;
        }

        String getTestPath() {
            return this.id == null ? TestManager.pathToString(this.file) : TestManager.pathToString(this.file) + "#" + this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestSpec testSpec = (TestSpec)o;
            return this.file.equals(testSpec.file) && Objects.equals(this.id, testSpec.id) && Objects.equals(this.query, testSpec.query);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.id, this.query);
        }

        public String toString() {
            return this.file + (String)(this.id == null ? "" : "#" + this.id) + (String)(this.query == null ? "" : "?" + this.query);
        }
    }

    private static class Entry {
        final Path rootDir;
        boolean all = false;
        final Set<TestSpec> tests = new LinkedHashSet<TestSpec>();
        final Set<String> groups = new LinkedHashSet<String>();
        RegressionTestSuite testSuite;
        String subdir;
        WorkDirectory workDir;
        Path reportDir;

        Entry(Path rootDir) {
            this.rootDir = rootDir;
        }
    }

    public static class GroupSpec {
        final Path dir;
        final String groupName;
        static final Pattern groupPtn = System.getProperty("os.name").matches("(?i)windows.*") ? Pattern.compile("(?<dir>|[^A-Za-z?]|[^?]{2,}):(?<group>[A-Za-z0-9_,]+)") : Pattern.compile("(?<dir>[^?]*):(?<group>[A-Za-z0-9_,]+)");

        public static boolean isGroupSpec(String s) {
            return groupPtn.matcher(s).matches();
        }

        public static GroupSpec of(String s) {
            Matcher m = groupPtn.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException(s);
            }
            String d = m.group("dir");
            Path dir = d.isEmpty() ? null : Path.of(d, new String[0]);
            String groupName = m.group("group");
            return new GroupSpec(dir, groupName);
        }

        private GroupSpec(Path dir, String groupName) {
            this.dir = dir;
            this.groupName = Objects.requireNonNull(groupName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupSpec groupSpec = (GroupSpec)o;
            return Objects.equals(this.dir, groupSpec.dir) && this.groupName.equals(groupSpec.groupName);
        }

        public int hashCode() {
            return Objects.hash(this.dir, this.groupName);
        }

        public String toString() {
            return (Comparable)(this.dir == null ? "" : this.dir) + ":" + this.groupName;
        }
    }

    public static class NoTests
    extends Main.Fault {
        private static final long serialVersionUID = 1L;

        public NoTests() {
            super(i18n, "tm.noTests", new Object[0]);
        }
    }
}

