/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.agent.AppletWrapper;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AppletAction
extends Action {
    public static final String NAME = "applet";
    private String manual = "unset";
    private boolean reverseStatus = false;
    private boolean othervm = false;
    private int timeout = -1;
    private File policyFN = null;
    private String secureFN = null;
    private boolean overrideSysPolicy = false;
    private String htmlFN;
    private String clsName;
    private HTMLFileContents htmlFileContents;
    private static final Object appletLock = new Object();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        super.init(opts, args, reason, script);
        if (args.size() != 1) {
            throw new ParseException("`applet' requires exactly one file argument");
        }
        block18: for (Map.Entry<String, String> e : opts.entrySet()) {
            String optName = e.getKey();
            String optValue = e.getValue();
            switch (optName) {
                case "fail": {
                    this.reverseStatus = this.parseFail(optValue);
                    continue block18;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(optValue);
                    continue block18;
                }
                case "manual": {
                    this.manual = this.parseAppletManual(optValue);
                    continue block18;
                }
                case "othervm": {
                    this.othervm = true;
                    continue block18;
                }
                case "policy": {
                    this.overrideSysPolicy = true;
                    this.policyFN = this.parsePolicy(optValue);
                    continue block18;
                }
                case "java.security.policy": {
                    String name = optValue;
                    if (optValue.startsWith("=")) {
                        this.overrideSysPolicy = true;
                        name = optValue.substring(1);
                    }
                    this.policyFN = this.parsePolicy(name);
                    continue block18;
                }
                case "secure": {
                    this.secureFN = this.parseSecure(optValue);
                    continue block18;
                }
            }
            throw new ParseException("Bad option for applet: " + optName);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = script.getActionTimeout(-1);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        if (!this.othervm) {
            if (this.policyFN != null) {
                throw new ParseException("`/policy' and `/java.security.policy` require use of `/othervm'");
            }
            if (this.secureFN != null) {
                throw new ParseException("`/secure' requires use of `/othervm'");
            }
        }
        this.htmlFN = args.get(0);
    }

    @Override
    public Set<File> getSourceFiles() {
        return Set.of(this.script.absTestSrcDir().resolve(this.htmlFN).toFile());
    }

    @Override
    public Status run() throws TestRunException {
        List<String> buildArgs;
        Map<String, String> buildOpts;
        BuildAction ba;
        Status status;
        this.htmlFileContents = new HTMLFileContents(this.htmlFN);
        this.clsName = this.htmlFileContents.getAppletAttrs().get("code");
        if (this.clsName.endsWith(".class")) {
            this.clsName = this.clsName.substring(0, this.clsName.lastIndexOf(".class"));
        }
        if (!(status = (ba = new BuildAction()).build(buildOpts = Collections.emptyMap(), buildArgs = List.of(this.clsName), "Named class compiled on demand", this.script)).isPassed()) {
            return status;
        }
        this.startAction(false);
        status = this.script.isCheck() ? RStatus.passed("Test description appears acceptable") : this.runOtherJVM();
        this.endAction(status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        Status status;
        Map<RegressionScript.PathKind, SearchPath> execPaths = this.script.getExecutionPaths(false, null, false, true);
        Map<RegressionScript.PathKind, SearchPath> compatExecPaths = this.script.getExecutionPaths(false, null, false, false);
        File argFile = this.getArgFile();
        try (BufferedWriter w = new BufferedWriter(new FileWriter(argFile));){
            w.write(this.clsName + "\u0000");
            w.write(this.script.absTestSrcDir() + "\u0000");
            w.write(this.script.absTestClsDir() + "\u0000");
            w.write(compatExecPaths.get((Object)RegressionScript.PathKind.CLASSPATH) + "\u0000");
            w.write(this.manual + "\u0000");
            w.write(this.htmlFileContents.getBody() + "\u0000");
            w.write(AppletAction.toString(this.htmlFileContents.getAppletParams()) + "\u0000");
            w.write(AppletAction.toString(this.htmlFileContents.getAppletAttrs()) + "\u0000");
        }
        catch (IOException e) {
            return RStatus.error("Can't write `applet' argument file");
        }
        ArrayList<String> command = new ArrayList<String>(6);
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        command.add(this.script.getJavaProg().toString());
        command.add("-classpath");
        command.add(execPaths.get((Object)RegressionScript.PathKind.CLASSPATH).toString());
        JDKOpts vmOpts = new JDKOpts();
        vmOpts.addAll(this.getExtraModuleConfigOptions(Modules.Phase.DYNAMIC));
        vmOpts.addAll(this.script.getTestVMJavaOptions());
        vmOpts.addAll(this.script.getTestDebugOptions());
        command.addAll(vmOpts.toList());
        for (Map.Entry<String, String> e : this.script.getTestProperties().entrySet()) {
            command.add("-D" + e.getKey() + "=" + e.getValue());
        }
        String headless = System.getProperty("java.awt.headless");
        if (headless != null) {
            command.add("-Djava.awt.headless=" + headless);
        }
        boolean mx = false;
        for (String opt : vmOpts.toList()) {
            if (!opt.startsWith("-mx") && !opt.startsWith("-Xmx")) continue;
            mx = true;
            break;
        }
        if (!mx) {
            command.add("-mx128m");
        }
        if (this.policyFN != null) {
            File newPolicyFN = this.addGrantEntries(this.policyFN);
            String cmd = this.overrideSysPolicy ? "-Djava.security.policy==" + newPolicyFN : "-Djava.security.policy=" + newPolicyFN;
            command.add(cmd);
        }
        if (this.secureFN != null) {
            command.add("-Djava.security.manager=" + this.secureFN);
        } else if (this.policyFN != null) {
            command.add("-Djava.security.manager=default");
        }
        command.add(AppletWrapper.class.getName());
        command.add(argFile.getPath());
        env.putAll(this.script.getEnvVars());
        try (PrintWriter sysOut = this.section.createOutput("System.out");
             PrintWriter sysErr = this.section.createOutput("System.err");){
            if (showCmd) {
                this.showCmd(NAME, command, this.section);
            }
            this.recorder.exec(command, env);
            ProcessCommand cmd = new ProcessCommand();
            cmd.setMessageWriter(this.section.getMessageWriter());
            cmd.setExecDir(this.script.absTestScratchDir().toFile());
            cmd.setStatusForExit(Status.exitCodes[0], RStatus.passed("Execution successful"));
            cmd.setStatusForExit(Status.exitCodes[1], RStatus.failed("Execution failed"));
            cmd.setDefaultStatus(RStatus.failed("Unexpected exit from test"));
            TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
            cmd.setCommand(command).setEnvironment(env).setStreams(sysOut, sysErr).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
            Object object = appletLock;
            synchronized (object) {
                status = RStatus.normalize(cmd.exec());
            }
        }
        if (!status.isError() && !status.getReason().startsWith("Unexpected exit from test")) {
            Object sr;
            if (status.getReason().equals("")) {
                boolean uEval = this.manual.equals("yesno");
                boolean manualp = this.manual.equals("yesno") || this.manual.equals("done");
                String uEvalString = uEval ? ", user evaluated" : "";
                sr = manualp ? "Manual test" + uEvalString + ": " : "";
            } else {
                sr = "";
            }
            boolean ok = status.isPassed();
            int st = status.getType();
            if (ok && this.reverseStatus) {
                sr = (String)sr + "Execution passed unexpectedly";
                st = 1;
            } else if (ok && !this.reverseStatus) {
                sr = (String)sr + "Execution successful";
            } else if (!ok && this.reverseStatus) {
                sr = (String)sr + "Execution failed as expected";
                st = 0;
            } else {
                sr = (String)sr + "Execution failed";
            }
            if (st == 1 && !status.getReason().equals("") && !status.getReason().equals("Execution successful")) {
                sr = (String)sr + ": " + status.getReason();
            }
            status = RStatus.createStatus(st, (String)sr);
        }
        return status;
    }

    private String parseAppletManual(String value) throws ParseException {
        if (value == null) {
            return "novalue";
        }
        if (!value.equals("yesno") && !value.equals("done")) {
            throw new ParseException("Bad value for `manual' option: " + value);
        }
        return value;
    }

    private static String toString(Map<String, String> d) {
        StringBuilder retVal = new StringBuilder();
        for (Map.Entry<String, String> e : d.entrySet()) {
            retVal.append(e.getKey());
            retVal.append("\u001c");
            retVal.append(e.getValue());
            retVal.append("\u001c");
        }
        return retVal.toString();
    }

    private class HTMLFileContents {
        String body;
        Map<String, String> appletParams = new HashMap<String, String>(1);
        Map<String, String> appletAttrs;

        HTMLFileContents(String htmlFN) throws TestRunException {
            int[] paramPos;
            String[] requiredAtts;
            String lowerBody;
            StringBuilder sb = new StringBuilder();
            htmlFN = AppletAction.this.script.absTestSrcDir().resolve(htmlFN).toString();
            try (BufferedReader in = new BufferedReader(new FileReader(htmlFN));){
                String line;
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                    sb.append(Action.LINESEP);
                }
            }
            catch (FileNotFoundException e) {
                throw new TestRunException("Can't find HTML file: " + htmlFN);
            }
            catch (IOException e) {
                throw new TestRunException("Problem reading HTML file: " + htmlFN);
            }
            String contents = sb.toString();
            String lower = contents.toLowerCase();
            int[] bodyPos = this.getTagPositions(contents, lower, "body", 0);
            if (bodyPos == null) {
                this.body = contents;
                lowerBody = lower;
            } else {
                int[] endBodyPos = this.getTagPositions(contents, lower, "/body", bodyPos[3] - 1);
                if (endBodyPos == null) {
                    throw new ParseException("No </body> tag in " + htmlFN);
                }
                this.body = contents.substring(bodyPos[3], endBodyPos[0]);
                lowerBody = lower.substring(bodyPos[3], endBodyPos[0]);
            }
            int[] appletPos = this.getTagPositions(this.body, lowerBody, AppletAction.NAME, 0);
            if (appletPos == null) {
                throw new ParseException("No <applet> tag in " + htmlFN);
            }
            int[] endAppletPos = this.getTagPositions(this.body, lowerBody, "/applet", appletPos[3] - 1);
            if (endAppletPos == null) {
                throw new ParseException("No </applet> tag in " + htmlFN);
            }
            this.appletAttrs = this.parseAttrs(this.body.substring(appletPos[1], appletPos[2]));
            for (String requiredAtt : requiredAtts = new String[]{"code", "width", "height"}) {
                if (this.appletAttrs.get(requiredAtt) != null) continue;
                throw new ParseException(htmlFN + " missing required attribute " + requiredAtt);
            }
            if (this.appletAttrs.get("archive") != null) {
                throw new ParseException("`archive' not supported in file: " + htmlFN);
            }
            String appletBody = this.body.substring(appletPos[3], endAppletPos[0]);
            String lowerAppletBody = appletBody.toLowerCase();
            int startPos = 0;
            while ((paramPos = this.getTagPositions(appletBody, lowerAppletBody, "param", startPos)) != null) {
                Map<String, String> d = this.parseAttrs(appletBody.substring(paramPos[1], paramPos[2]));
                String name = d.get("name");
                String value = d.get("value");
                if (name == null || value == null) {
                    throw new ParseException("Missing required name or value for param in <param> tag");
                }
                this.appletParams.put(name, value);
                startPos = paramPos[3];
            }
        }

        String getBody() {
            return this.body;
        }

        Map<String, String> getAppletParams() {
            return this.appletParams;
        }

        Map<String, String> getAppletAttrs() {
            return this.appletAttrs;
        }

        private int[] getAttrPositions(String attrs, int startPos) {
            try {
                int valEnd;
                char c;
                int nameStart = startPos;
                while (Character.isWhitespace(attrs.charAt(nameStart))) {
                    ++nameStart;
                }
                int nameEnd = nameStart;
                while (!Character.isWhitespace(c = attrs.charAt(nameEnd)) && c != '=') {
                    ++nameEnd;
                }
                int valStart = nameEnd;
                while (Character.isWhitespace(attrs.charAt(valStart))) {
                    ++valStart;
                }
                if (attrs.charAt(valStart) != '=') {
                    return null;
                }
                ++valStart;
                while (Character.isWhitespace(attrs.charAt(valStart))) {
                    ++valStart;
                }
                int theEnd = attrs.length();
                boolean inString = false;
                for (valEnd = valStart; valEnd < theEnd; ++valEnd) {
                    char c2 = attrs.charAt(valEnd);
                    if (!inString && Character.isWhitespace(c2)) break;
                    if (c2 == '\"') {
                        boolean bl = inString = !inString;
                    }
                    if (c2 != '\\' || valEnd >= theEnd - 1) continue;
                    ++valEnd;
                }
                if (nameEnd <= nameStart || valEnd <= valStart) {
                    return null;
                }
                return new int[]{nameStart, nameEnd, valStart, valEnd};
            }
            catch (StringIndexOutOfBoundsException e) {
                return null;
            }
        }

        private int[] getTagPositions(String contents, String lower, String tagName, int index) {
            int tagStart = lower.indexOf("<" + tagName, index);
            if (tagStart == -1) {
                return null;
            }
            int tagEnd = lower.indexOf(">", tagStart);
            if (tagEnd == -1) {
                return null;
            }
            return new int[]{tagStart, tagStart + tagName.length() + 1, tagEnd, tagEnd + 1};
        }

        private Map<String, String> parseAttrs(String attrs) {
            int[] positions;
            HashMap<String, String> result = new HashMap<String, String>(3);
            int startPos = 0;
            while ((positions = this.getAttrPositions(attrs, startPos)) != null) {
                String value = attrs.substring(positions[2], positions[3]);
                if (value.indexOf("\"") == 0 && value.lastIndexOf("\"") == value.length() - 1) {
                    value = value.substring(1, value.length() - 1);
                }
                result.put(attrs.substring(positions[0], positions[1]).toLowerCase(), value);
                startPos = positions[3];
            }
            return result;
        }
    }
}

