/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;

public class CleanAction
extends Action {
    public static final String NAME = "clean";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        super.init(opts, args, reason, script);
        if (!opts.isEmpty()) {
            throw new ParseException("Unexpected option(s) for `clean'");
        }
        if (args.isEmpty()) {
            throw new ParseException("No classname(s) provided for `clean'");
        }
        for (String arg : args) {
            String name;
            if ("*".equals(arg)) continue;
            String string = name = arg.endsWith(".*") ? arg.substring(0, arg.length() - 2) : arg;
            if (SourceVersion.isName(name)) continue;
            throw new ParseException("Bad classname provided for `clean': " + arg);
        }
    }

    @Override
    public Status run() throws TestRunException {
        Status status = RStatus.passed("Clean successful");
        this.startAction(false);
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            for (String arg : this.args) {
                if (arg.equals("*")) {
                    arg = ".*";
                }
                if (arg.endsWith(".*")) {
                    String path = arg.substring(0, arg.length() - 2);
                    path = path.replace('.', File.separatorChar);
                    File dir = this.script.absTestClsDir().toFile();
                    if (!path.equals("")) {
                        dir = new File(dir, path);
                    }
                    this.recorder.exec("for f in " + dir + "/*; do\n  if [ -f $f ]; then rm $f ; fi\ndone");
                    try {
                        File[] files;
                        if (!dir.isDirectory() || (files = dir.listFiles()) == null) continue;
                        for (File f : files) {
                            if (f.delete() || f.isDirectory()) continue;
                            throw new TestRunException("`clean' unable to delete file: " + f);
                        }
                        continue;
                    }
                    catch (SecurityException e) {
                        throw new TestRunException("Problem deleting directory contents: " + dir);
                    }
                }
                File victim = this.script.absTestClsDir().resolve(arg.replace('.', File.separatorChar) + ".class").toFile();
                this.recorder.exec("rm -f " + victim);
                if (!victim.exists() || victim.delete()) continue;
                return RStatus.error("`clean' unable to delete file: " + victim);
            }
        }
        this.endAction(status);
        return status;
    }

    @Override
    public Set<File> getSourceFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String arg : this.args) {
            try {
                for (Locations.ClassLocn cl : this.script.locations.locateClasses(arg)) {
                    if (!Files.exists(cl.absSrcFile, new LinkOption[0])) continue;
                    files.add(cl.absSrcFile.toFile());
                }
            }
            catch (Locations.Fault fault) {
            }
        }
        return files;
    }
}

