/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.StringUtils;
import java.util.List;
import java.util.Map;

public class IgnoreAction
extends Action {
    public static final String NAME = "ignore";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        super.init(opts, args, reason, script);
        if (!opts.isEmpty()) {
            throw new ParseException("Unexpected option(s) for `ignore'");
        }
    }

    @Override
    public Status run() throws TestRunException {
        Status status;
        this.startAction(false);
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            switch (this.script.getIgnoreKind()) {
                case QUIET: {
                    throw new IllegalStateException();
                }
                case ERROR: {
                    this.recorder.exec("# @ignore: " + StringUtils.join(this.args, " ") + "\nexit 1");
                    if (this.args.isEmpty()) {
                        status = RStatus.error("Test ignored");
                        break;
                    }
                    status = RStatus.error("Test ignored: " + StringUtils.join(this.args, " "));
                    break;
                }
                case RUN: {
                    this.recorder.exec("# @ignore: " + StringUtils.join(this.args, " ") + " (suppressed)");
                    if (this.args.isEmpty()) {
                        status = RStatus.passed("@ignore suppressed by command line option");
                        break;
                    }
                    status = RStatus.passed("@ignore suppressed by command line option: " + StringUtils.join(this.args, " "));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.endAction(status);
        return status;
    }
}

