/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.regtest.report.XPrintStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class XMLWriter {
    static final String PASSED = "Passed.";
    static final String FAILED = "Failed.";
    public final TestResult tr;
    private final XPrintStream xps;
    private final String classname;
    private final Date start;
    private final double duration;
    private final Status status;
    private final File xmlFile;
    private final boolean verify;
    private final PrintWriter harnessOut;
    private final PrintWriter harnessErr;
    private final SimpleDateFormat defDateFmt;
    private final DateFormat isoDateFmt;

    XMLWriter(TestResult tr, boolean mustVerify, PrintWriter out, PrintWriter err) throws ParseException, UnsupportedEncodingException, TestResult.Fault {
        String encoding = Charset.defaultCharset().name();
        this.defDateFmt = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy", Locale.US);
        this.isoDateFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        this.harnessOut = out;
        this.harnessErr = err;
        this.xps = new XPrintStream(this.harnessOut, this.harnessErr, encoding);
        this.tr = tr;
        this.verify = mustVerify;
        this.status = tr.getStatus();
        this.classname = tr.getProperty("test");
        this.xmlFile = new File(tr.getFile().getAbsolutePath() + ".xml");
        this.start = this.defDateFmt.parse(tr.getProperty("start"));
        this.duration = this.getElapsedTime();
        this.process(encoding);
    }

    private double getElapsedTime() throws TestResult.Fault {
        String elapsedTime = this.tr.getProperty("elapsed");
        if (elapsedTime == null) {
            elapsedTime = this.tr.getProperty("totalTime");
        }
        if (elapsedTime == null) {
            return 0.0;
        }
        String[] f = elapsedTime.split("\\s");
        double elapsed = Double.parseDouble(f[0]);
        return elapsed / 1000.0;
    }

    private void createHeader(String encoding) {
        this.xps.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>");
    }

    private void startTestSuite() throws TestResult.Fault {
        this.xps.print("<testsuite");
        this.xps.print(" errors=\"");
        this.xps.print(this.status.isError() ? "1" : "0");
        this.xps.print("\"");
        this.xps.print(" failures=\"");
        this.xps.print(this.status.isFailed() ? "1" : "0");
        this.xps.print("\"");
        this.xps.print(" tests=\"1\"");
        this.xps.print(" hostname=\"");
        this.xps.print(this.tr.getProperty("hostname"));
        this.xps.print("\"");
        this.xps.print(" name=\"");
        this.xps.print(this.classname);
        this.xps.print("\"");
        this.xps.print(" time=\"");
        this.xps.print(this.duration);
        this.xps.print("\"");
        this.xps.print(" timestamp=\"");
        this.xps.print(this.isoDateFmt.format(this.start));
        this.xps.print("\"");
        this.xps.println(">");
    }

    private void endTestSuite() {
        this.xps.println("</testsuite>");
    }

    private void insertProperties() throws TestResult.Fault {
        this.xps.indent();
        this.xps.println("<properties>");
        TestDescription td = this.tr.getDescription();
        Iterator<String> iterator = td.getParameterKeys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            this.xps.indent(2);
            this.xps.print("<property name=\"");
            this.xps.print(key);
            this.xps.print("\"");
            this.xps.print(" value=\"");
            this.xps.sanitize(td.getParameter(key));
            this.xps.println("\" />");
        }
        Enumeration<String> e = this.tr.getPropertyNames();
        while (e.hasMoreElements()) {
            String x = e.nextElement();
            this.xps.indent(2);
            this.xps.print("<property name=\"");
            this.xps.print(x);
            this.xps.print("\"");
            this.xps.print(" value=\"");
            this.xps.sanitize(this.tr.getProperty(x));
            this.xps.println("\" />");
        }
        this.xps.indent();
        this.xps.println("</properties>");
    }

    private String getOutput(String name) throws TestResult.Fault {
        String[] titles = this.tr.getSectionTitles();
        for (int i = 0; i < titles.length; ++i) {
            TestResult.Section s;
            String[] stringArray;
            int n;
            int n2;
            if (!titles[i].equals("main") && !titles[i].equals("shell") && !titles[i].equals("compile") || (n2 = 0) >= (n = (stringArray = (s = this.tr.getSection(i)).getOutputNames()).length)) continue;
            String x = stringArray[n2];
            return s.getOutput(name);
        }
        return "";
    }

    private void insertSystemOut() throws TestResult.Fault {
        this.xps.indent();
        this.xps.print("<system-out>");
        this.xps.sanitize(this.getOutput("System.out"));
        this.xps.indent();
        this.xps.println("</system-out>");
    }

    private void insertSystemErr() throws TestResult.Fault {
        this.xps.indent();
        this.xps.print("<system-err>");
        this.xps.sanitize(this.getOutput("System.err"));
        this.xps.indent();
        this.xps.println("</system-err>");
    }

    private void insertFailure() {
        if (this.status.isPassed()) {
            return;
        }
        this.xps.indent();
        this.xps.print("<failure type=\"");
        this.xps.print(FAILED);
        this.xps.println("\">");
        this.xps.sanitize(this.status.getReason());
        this.xps.indent();
        this.xps.println("");
        this.xps.println("</failure>");
    }

    private void insertTestCase() throws TestResult.Fault {
        this.xps.indent();
        this.xps.print("<testcase ");
        this.xps.print("classname=\"");
        this.xps.print(this.classname);
        this.xps.print("\"");
        this.xps.print(" name=\"");
        this.xps.print(this.tr.getDescription().getName());
        this.xps.print("\"");
        this.xps.print(" time=\"");
        this.xps.print(this.duration);
        this.xps.print("\"");
        this.xps.println(" >");
        this.insertFailure();
        this.xps.indent();
        this.xps.println("</testcase>");
    }

    private void process(String encoding) throws TestResult.Fault {
        this.createHeader(encoding);
        this.startTestSuite();
        this.insertProperties();
        this.insertTestCase();
        this.insertSystemOut();
        this.insertSystemErr();
        this.endTestSuite();
    }

    public String toString() {
        return this.xps.toString();
    }

    public void toXML() throws IOException {
        File baseDir = this.xmlFile.getParentFile();
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(this.xmlFile);){
            this.xps.writeTo(fos);
        }
        if (this.verify) {
            this.xps.verifyXML(this.xmlFile);
        }
    }

    private static void usage(PrintStream out, String message) {
        if (message != null) {
            out.println(message);
        }
        out.println("Usage:");
        out.println("  java -cp jtreg.jar com.sun.javatest.regtest.XMLWriter -@list");
        out.println("      where list is a file containing the .jtr files to be processed");
        out.println("  java -cp jtreg.jar com.sun.javatest.regtest.XMLWriter dir");
        out.println("      where dir is a JTwork dir containing the .jtr files to be processed");
        out.println("  java -cp jtreg.jar com.sun.javatest.regtest.XMLWriter 1.jtr 2.jtr.. n.jtr");
        out.println("      where args are a list of .jtr files to be processed");
        System.exit(1);
    }

    private static List<File> fileToList(String arg) throws Exception {
        ArrayList<File> outList = new ArrayList<File>();
        String in = arg.replaceFirst("^-@|^@", "");
        try (BufferedReader br = new BufferedReader(new FileReader(in));){
            String line = br.readLine();
            while (line != null) {
                outList.add(new File(line));
                line = br.readLine();
            }
        }
        return outList;
    }

    private static void scan(File file, List<File> xlist) {
        if (file.isFile() && file.getName().endsWith(".jtr")) {
            xlist.add(file);
        } else if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                XMLWriter.scan(f, xlist);
            }
        }
    }

    private static List<File> dirToList(File f) {
        ArrayList<File> outList = new ArrayList<File>();
        XMLWriter.scan(f, outList);
        return outList;
    }

    private static void translateList(List<File> xmlFileList) throws Exception {
        if (xmlFileList == null || xmlFileList.isEmpty()) {
            XMLWriter.usage(System.out, "Warning: nothing to process");
            return;
        }
        for (File jtrFile : xmlFileList) {
            if (jtrFile.exists() && jtrFile.isFile() && jtrFile.getName().endsWith(".jtr")) {
                XMLWriter jutr = new XMLWriter(new TestResult(jtrFile), true, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
                jutr.toXML();
                continue;
            }
            System.out.println("Warning: skipping file " + jtrFile);
        }
    }

    private static List<File> argsToList(String ... args) {
        ArrayList<File> outList = new ArrayList<File>();
        for (String x : args) {
            outList.add(new File(x));
        }
        return outList;
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length < 1) {
                XMLWriter.usage(System.err, "Error: insufficent arguments");
            }
            if (args[0].startsWith("-@") || args[0].startsWith("@")) {
                XMLWriter.translateList(XMLWriter.fileToList(args[0]));
            } else {
                File f = new File(args[0]);
                if (f.isDirectory()) {
                    XMLWriter.translateList(XMLWriter.dirToList(f));
                } else {
                    XMLWriter.translateList(XMLWriter.argsToList(args));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static class XMLHarnessObserver
    extends BasicObserver {
        private final boolean mustVerify;
        private final PrintWriter harnessOut;
        private final PrintWriter harnessErr;

        public XMLHarnessObserver(boolean mustVerify, PrintWriter out, PrintWriter err) {
            this.harnessOut = out;
            this.harnessErr = err;
            this.mustVerify = mustVerify;
        }

        @Override
        public synchronized void finishedTest(TestResult tr) {
            try {
                super.finishedTest(tr);
                new XMLWriter(tr, this.mustVerify, this.harnessOut, this.harnessErr).toXML();
            }
            catch (TestResult.Fault | IOException | ParseException ex) {
                ex.printStackTrace(this.harnessOut);
            }
        }
    }
}

